;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-merge %s first %s.second second -S -o - | filecheck %s --check-prefix=CHECK-TEXT
;; RUN: wasm-as %s -o %t.wasm --source-map %t.map
;; RUN: wasm-as %s.second -o %t.second.wasm --source-map %t.second.map
;; RUN: wasm-merge %t.wasm first --input-source-map %t.map  %t.second.wasm second --input-source-map %t.second.map -o %t.merged.wasm --output-source-map %t.merged.map
;; RUN: wasm-dis %t.merged.wasm --source-map %t.merged.map -o - | filecheck %s --check-prefix=CHECK-BIN

;; Test that sourcemap information is preserved

(module
  ;;@ a:1:1
  (func (export "f")
     ;;@ a:2:1
     (nop)
     ;;@ a:3:1
  )
)
;; CHECK-TEXT:      (type $0 (func))

;; CHECK-TEXT:      (export "f" (func $0))

;; CHECK-TEXT:      (export "g" (func $0_1))

;; CHECK-TEXT:      (func $0
;; CHECK-TEXT-NEXT:  ;;@ a:2:1
;; CHECK-TEXT-NEXT:  (nop)
;; CHECK-TEXT-NEXT:  ;;@ a:3:1
;; CHECK-TEXT-NEXT: )

;; CHECK-TEXT:      (func $0_1
;; CHECK-TEXT-NEXT:  ;;@ b:2:2
;; CHECK-TEXT-NEXT:  (nop)
;; CHECK-TEXT-NEXT:  ;;@ b:3:2
;; CHECK-TEXT-NEXT: )

;; CHECK-BIN:      (type $0 (func))

;; CHECK-BIN:      (export "f" (func $0))

;; CHECK-BIN:      (export "g" (func $1))

;; CHECK-BIN:      (func $0
;; CHECK-BIN-NEXT:  ;;@ a:2:1
;; CHECK-BIN-NEXT:  (nop)
;; CHECK-BIN-NEXT:  ;;@ a:3:1
;; CHECK-BIN-NEXT: )

;; CHECK-BIN:      (func $1
;; CHECK-BIN-NEXT:  ;;@ b:2:2
;; CHECK-BIN-NEXT:  (nop)
;; CHECK-BIN-NEXT:  ;;@ b:3:2
;; CHECK-BIN-NEXT: )
