﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/datazone/model/BusinessNameGenerationConfiguration.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace DataZone
{
namespace Model
{

BusinessNameGenerationConfiguration::BusinessNameGenerationConfiguration() : 
    m_enabled(false),
    m_enabledHasBeenSet(false)
{
}

BusinessNameGenerationConfiguration::BusinessNameGenerationConfiguration(JsonView jsonValue)
  : BusinessNameGenerationConfiguration()
{
  *this = jsonValue;
}

BusinessNameGenerationConfiguration& BusinessNameGenerationConfiguration::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("enabled"))
  {
    m_enabled = jsonValue.GetBool("enabled");

    m_enabledHasBeenSet = true;
  }

  return *this;
}

JsonValue BusinessNameGenerationConfiguration::Jsonize() const
{
  JsonValue payload;

  if(m_enabledHasBeenSet)
  {
   payload.WithBool("enabled", m_enabled);

  }

  return payload;
}

} // namespace Model
} // namespace DataZone
} // namespace Aws
