﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/datasync/model/TaskQueueing.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace DataSync
  {
    namespace Model
    {
      namespace TaskQueueingMapper
      {

        static const int ENABLED_HASH = HashingUtils::HashString("ENABLED");
        static const int DISABLED_HASH = HashingUtils::HashString("DISABLED");


        TaskQueueing GetTaskQueueingForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == ENABLED_HASH)
          {
            return TaskQueueing::ENABLED;
          }
          else if (hashCode == DISABLED_HASH)
          {
            return TaskQueueing::DISABLED;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<TaskQueueing>(hashCode);
          }

          return TaskQueueing::NOT_SET;
        }

        Aws::String GetNameForTaskQueueing(TaskQueueing enumValue)
        {
          switch(enumValue)
          {
          case TaskQueueing::NOT_SET:
            return {};
          case TaskQueueing::ENABLED:
            return "ENABLED";
          case TaskQueueing::DISABLED:
            return "DISABLED";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace TaskQueueingMapper
    } // namespace Model
  } // namespace DataSync
} // namespace Aws
