﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codepipeline/model/ListRuleExecutionsResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::CodePipeline::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListRuleExecutionsResult::ListRuleExecutionsResult()
{
}

ListRuleExecutionsResult::ListRuleExecutionsResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

ListRuleExecutionsResult& ListRuleExecutionsResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("ruleExecutionDetails"))
  {
    Aws::Utils::Array<JsonView> ruleExecutionDetailsJsonList = jsonValue.GetArray("ruleExecutionDetails");
    for(unsigned ruleExecutionDetailsIndex = 0; ruleExecutionDetailsIndex < ruleExecutionDetailsJsonList.GetLength(); ++ruleExecutionDetailsIndex)
    {
      m_ruleExecutionDetails.push_back(ruleExecutionDetailsJsonList[ruleExecutionDetailsIndex].AsObject());
    }
  }

  if(jsonValue.ValueExists("nextToken"))
  {
    m_nextToken = jsonValue.GetString("nextToken");

  }


  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if(requestIdIter != headers.end())
  {
    m_requestId = requestIdIter->second;
  }


  return *this;
}
