﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codepipeline/model/ArtifactLocationType.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace CodePipeline
  {
    namespace Model
    {
      namespace ArtifactLocationTypeMapper
      {

        static const int S3_HASH = HashingUtils::HashString("S3");


        ArtifactLocationType GetArtifactLocationTypeForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == S3_HASH)
          {
            return ArtifactLocationType::S3;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<ArtifactLocationType>(hashCode);
          }

          return ArtifactLocationType::NOT_SET;
        }

        Aws::String GetNameForArtifactLocationType(ArtifactLocationType enumValue)
        {
          switch(enumValue)
          {
          case ArtifactLocationType::NOT_SET:
            return {};
          case ArtifactLocationType::S3:
            return "S3";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace ArtifactLocationTypeMapper
    } // namespace Model
  } // namespace CodePipeline
} // namespace Aws
