﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appsync/AppSync_EXPORTS.h>
#include <aws/appsync/AppSyncRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace AppSync
{
namespace Model
{

  /**
   */
  class DisassociateMergedGraphqlApiRequest : public AppSyncRequest
  {
  public:
    AWS_APPSYNC_API DisassociateMergedGraphqlApiRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "DisassociateMergedGraphqlApi"; }

    AWS_APPSYNC_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>The identifier of the AppSync Source API. This is generated by the AppSync
     * service. In most cases, source APIs (especially in your account) only require
     * the API ID value or ARN of the source API. However, source APIs from other
     * accounts (cross-account use cases) strictly require the full resource ARN of the
     * source API.</p>
     */
    inline const Aws::String& GetSourceApiIdentifier() const{ return m_sourceApiIdentifier; }
    inline bool SourceApiIdentifierHasBeenSet() const { return m_sourceApiIdentifierHasBeenSet; }
    inline void SetSourceApiIdentifier(const Aws::String& value) { m_sourceApiIdentifierHasBeenSet = true; m_sourceApiIdentifier = value; }
    inline void SetSourceApiIdentifier(Aws::String&& value) { m_sourceApiIdentifierHasBeenSet = true; m_sourceApiIdentifier = std::move(value); }
    inline void SetSourceApiIdentifier(const char* value) { m_sourceApiIdentifierHasBeenSet = true; m_sourceApiIdentifier.assign(value); }
    inline DisassociateMergedGraphqlApiRequest& WithSourceApiIdentifier(const Aws::String& value) { SetSourceApiIdentifier(value); return *this;}
    inline DisassociateMergedGraphqlApiRequest& WithSourceApiIdentifier(Aws::String&& value) { SetSourceApiIdentifier(std::move(value)); return *this;}
    inline DisassociateMergedGraphqlApiRequest& WithSourceApiIdentifier(const char* value) { SetSourceApiIdentifier(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline const Aws::String& GetAssociationId() const{ return m_associationId; }
    inline bool AssociationIdHasBeenSet() const { return m_associationIdHasBeenSet; }
    inline void SetAssociationId(const Aws::String& value) { m_associationIdHasBeenSet = true; m_associationId = value; }
    inline void SetAssociationId(Aws::String&& value) { m_associationIdHasBeenSet = true; m_associationId = std::move(value); }
    inline void SetAssociationId(const char* value) { m_associationIdHasBeenSet = true; m_associationId.assign(value); }
    inline DisassociateMergedGraphqlApiRequest& WithAssociationId(const Aws::String& value) { SetAssociationId(value); return *this;}
    inline DisassociateMergedGraphqlApiRequest& WithAssociationId(Aws::String&& value) { SetAssociationId(std::move(value)); return *this;}
    inline DisassociateMergedGraphqlApiRequest& WithAssociationId(const char* value) { SetAssociationId(value); return *this;}
    ///@}
  private:

    Aws::String m_sourceApiIdentifier;
    bool m_sourceApiIdentifierHasBeenSet = false;

    Aws::String m_associationId;
    bool m_associationIdHasBeenSet = false;
  };

} // namespace Model
} // namespace AppSync
} // namespace Aws
