﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <aws/ec2/model/NetworkInsightsPath.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Xml
{
  class XmlDocument;
} // namespace Xml
} // namespace Utils
namespace EC2
{
namespace Model
{
  class DescribeNetworkInsightsPathsResponse
  {
  public:
    AWS_EC2_API DescribeNetworkInsightsPathsResponse();
    AWS_EC2_API DescribeNetworkInsightsPathsResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
    AWS_EC2_API DescribeNetworkInsightsPathsResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);


    ///@{
    /**
     * <p>Information about the paths.</p>
     */
    inline const Aws::Vector<NetworkInsightsPath>& GetNetworkInsightsPaths() const{ return m_networkInsightsPaths; }
    inline void SetNetworkInsightsPaths(const Aws::Vector<NetworkInsightsPath>& value) { m_networkInsightsPaths = value; }
    inline void SetNetworkInsightsPaths(Aws::Vector<NetworkInsightsPath>&& value) { m_networkInsightsPaths = std::move(value); }
    inline DescribeNetworkInsightsPathsResponse& WithNetworkInsightsPaths(const Aws::Vector<NetworkInsightsPath>& value) { SetNetworkInsightsPaths(value); return *this;}
    inline DescribeNetworkInsightsPathsResponse& WithNetworkInsightsPaths(Aws::Vector<NetworkInsightsPath>&& value) { SetNetworkInsightsPaths(std::move(value)); return *this;}
    inline DescribeNetworkInsightsPathsResponse& AddNetworkInsightsPaths(const NetworkInsightsPath& value) { m_networkInsightsPaths.push_back(value); return *this; }
    inline DescribeNetworkInsightsPathsResponse& AddNetworkInsightsPaths(NetworkInsightsPath&& value) { m_networkInsightsPaths.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The token to use to retrieve the next page of results. This value is
     * <code>null</code> when there are no more results to return.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline DescribeNetworkInsightsPathsResponse& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline DescribeNetworkInsightsPathsResponse& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline DescribeNetworkInsightsPathsResponse& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const ResponseMetadata& GetResponseMetadata() const{ return m_responseMetadata; }
    inline void SetResponseMetadata(const ResponseMetadata& value) { m_responseMetadata = value; }
    inline void SetResponseMetadata(ResponseMetadata&& value) { m_responseMetadata = std::move(value); }
    inline DescribeNetworkInsightsPathsResponse& WithResponseMetadata(const ResponseMetadata& value) { SetResponseMetadata(value); return *this;}
    inline DescribeNetworkInsightsPathsResponse& WithResponseMetadata(ResponseMetadata&& value) { SetResponseMetadata(std::move(value)); return *this;}
    ///@}
  private:

    Aws::Vector<NetworkInsightsPath> m_networkInsightsPaths;

    Aws::String m_nextToken;

    ResponseMetadata m_responseMetadata;
  };

} // namespace Model
} // namespace EC2
} // namespace Aws
