﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/docdb-elastic/model/ListClusterSnapshotsRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::DocDBElastic::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

ListClusterSnapshotsRequest::ListClusterSnapshotsRequest() : 
    m_clusterArnHasBeenSet(false),
    m_maxResults(0),
    m_maxResultsHasBeenSet(false),
    m_nextTokenHasBeenSet(false),
    m_snapshotTypeHasBeenSet(false)
{
}

Aws::String ListClusterSnapshotsRequest::SerializePayload() const
{
  return {};
}

void ListClusterSnapshotsRequest::AddQueryStringParameters(URI& uri) const
{
    Aws::StringStream ss;
    if(m_clusterArnHasBeenSet)
    {
      ss << m_clusterArn;
      uri.AddQueryStringParameter("clusterArn", ss.str());
      ss.str("");
    }

    if(m_maxResultsHasBeenSet)
    {
      ss << m_maxResults;
      uri.AddQueryStringParameter("maxResults", ss.str());
      ss.str("");
    }

    if(m_nextTokenHasBeenSet)
    {
      ss << m_nextToken;
      uri.AddQueryStringParameter("nextToken", ss.str());
      ss.str("");
    }

    if(m_snapshotTypeHasBeenSet)
    {
      ss << m_snapshotType;
      uri.AddQueryStringParameter("snapshotType", ss.str());
      ss.str("");
    }

}



