﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/controlcatalog/model/GetControlRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::ControlCatalog::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

GetControlRequest::GetControlRequest() : 
    m_controlArnHasBeenSet(false)
{
}

Aws::String GetControlRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_controlArnHasBeenSet)
  {
   payload.WithString("ControlArn", m_controlArn);

  }

  return payload.View().WriteReadable();
}




