﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connect/model/TaskTemplateStatus.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace Connect
  {
    namespace Model
    {
      namespace TaskTemplateStatusMapper
      {

        static const int ACTIVE_HASH = HashingUtils::HashString("ACTIVE");
        static const int INACTIVE_HASH = HashingUtils::HashString("INACTIVE");


        TaskTemplateStatus GetTaskTemplateStatusForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == ACTIVE_HASH)
          {
            return TaskTemplateStatus::ACTIVE;
          }
          else if (hashCode == INACTIVE_HASH)
          {
            return TaskTemplateStatus::INACTIVE;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<TaskTemplateStatus>(hashCode);
          }

          return TaskTemplateStatus::NOT_SET;
        }

        Aws::String GetNameForTaskTemplateStatus(TaskTemplateStatus enumValue)
        {
          switch(enumValue)
          {
          case TaskTemplateStatus::NOT_SET:
            return {};
          case TaskTemplateStatus::ACTIVE:
            return "ACTIVE";
          case TaskTemplateStatus::INACTIVE:
            return "INACTIVE";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace TaskTemplateStatusMapper
    } // namespace Model
  } // namespace Connect
} // namespace Aws
