﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codecatalyst/CodeCatalyst_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/DateTime.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace CodeCatalyst
{
namespace Model
{
  class CreateAccessTokenResult
  {
  public:
    AWS_CODECATALYST_API CreateAccessTokenResult();
    AWS_CODECATALYST_API CreateAccessTokenResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_CODECATALYST_API CreateAccessTokenResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The secret value of the personal access token.</p>
     */
    inline const Aws::String& GetSecret() const{ return m_secret; }
    inline void SetSecret(const Aws::String& value) { m_secret = value; }
    inline void SetSecret(Aws::String&& value) { m_secret = std::move(value); }
    inline void SetSecret(const char* value) { m_secret.assign(value); }
    inline CreateAccessTokenResult& WithSecret(const Aws::String& value) { SetSecret(value); return *this;}
    inline CreateAccessTokenResult& WithSecret(Aws::String&& value) { SetSecret(std::move(value)); return *this;}
    inline CreateAccessTokenResult& WithSecret(const char* value) { SetSecret(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The friendly name of the personal access token.</p>
     */
    inline const Aws::String& GetName() const{ return m_name; }
    inline void SetName(const Aws::String& value) { m_name = value; }
    inline void SetName(Aws::String&& value) { m_name = std::move(value); }
    inline void SetName(const char* value) { m_name.assign(value); }
    inline CreateAccessTokenResult& WithName(const Aws::String& value) { SetName(value); return *this;}
    inline CreateAccessTokenResult& WithName(Aws::String&& value) { SetName(std::move(value)); return *this;}
    inline CreateAccessTokenResult& WithName(const char* value) { SetName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The date and time the personal access token expires, in coordinated universal
     * time (UTC) timestamp format as specified in <a
     * href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>. If not
     * specified, the default is one year from creation.</p>
     */
    inline const Aws::Utils::DateTime& GetExpiresTime() const{ return m_expiresTime; }
    inline void SetExpiresTime(const Aws::Utils::DateTime& value) { m_expiresTime = value; }
    inline void SetExpiresTime(Aws::Utils::DateTime&& value) { m_expiresTime = std::move(value); }
    inline CreateAccessTokenResult& WithExpiresTime(const Aws::Utils::DateTime& value) { SetExpiresTime(value); return *this;}
    inline CreateAccessTokenResult& WithExpiresTime(Aws::Utils::DateTime&& value) { SetExpiresTime(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The system-generated unique ID of the access token.</p>
     */
    inline const Aws::String& GetAccessTokenId() const{ return m_accessTokenId; }
    inline void SetAccessTokenId(const Aws::String& value) { m_accessTokenId = value; }
    inline void SetAccessTokenId(Aws::String&& value) { m_accessTokenId = std::move(value); }
    inline void SetAccessTokenId(const char* value) { m_accessTokenId.assign(value); }
    inline CreateAccessTokenResult& WithAccessTokenId(const Aws::String& value) { SetAccessTokenId(value); return *this;}
    inline CreateAccessTokenResult& WithAccessTokenId(Aws::String&& value) { SetAccessTokenId(std::move(value)); return *this;}
    inline CreateAccessTokenResult& WithAccessTokenId(const char* value) { SetAccessTokenId(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline CreateAccessTokenResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline CreateAccessTokenResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline CreateAccessTokenResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_secret;

    Aws::String m_name;

    Aws::Utils::DateTime m_expiresTime;

    Aws::String m_accessTokenId;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace CodeCatalyst
} // namespace Aws
