﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-messaging/ChimeSDKMessaging_EXPORTS.h>
#include <aws/chime-sdk-messaging/model/BatchChannelMemberships.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/chime-sdk-messaging/model/BatchCreateChannelMembershipError.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace ChimeSDKMessaging
{
namespace Model
{
  class BatchCreateChannelMembershipResult
  {
  public:
    AWS_CHIMESDKMESSAGING_API BatchCreateChannelMembershipResult();
    AWS_CHIMESDKMESSAGING_API BatchCreateChannelMembershipResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_CHIMESDKMESSAGING_API BatchCreateChannelMembershipResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The list of channel memberships in the response.</p>
     */
    inline const BatchChannelMemberships& GetBatchChannelMemberships() const{ return m_batchChannelMemberships; }
    inline void SetBatchChannelMemberships(const BatchChannelMemberships& value) { m_batchChannelMemberships = value; }
    inline void SetBatchChannelMemberships(BatchChannelMemberships&& value) { m_batchChannelMemberships = std::move(value); }
    inline BatchCreateChannelMembershipResult& WithBatchChannelMemberships(const BatchChannelMemberships& value) { SetBatchChannelMemberships(value); return *this;}
    inline BatchCreateChannelMembershipResult& WithBatchChannelMemberships(BatchChannelMemberships&& value) { SetBatchChannelMemberships(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>If the action fails for one or more of the memberships in the request, a list
     * of the memberships is returned, along with error codes and error messages.</p>
     */
    inline const Aws::Vector<BatchCreateChannelMembershipError>& GetErrors() const{ return m_errors; }
    inline void SetErrors(const Aws::Vector<BatchCreateChannelMembershipError>& value) { m_errors = value; }
    inline void SetErrors(Aws::Vector<BatchCreateChannelMembershipError>&& value) { m_errors = std::move(value); }
    inline BatchCreateChannelMembershipResult& WithErrors(const Aws::Vector<BatchCreateChannelMembershipError>& value) { SetErrors(value); return *this;}
    inline BatchCreateChannelMembershipResult& WithErrors(Aws::Vector<BatchCreateChannelMembershipError>&& value) { SetErrors(std::move(value)); return *this;}
    inline BatchCreateChannelMembershipResult& AddErrors(const BatchCreateChannelMembershipError& value) { m_errors.push_back(value); return *this; }
    inline BatchCreateChannelMembershipResult& AddErrors(BatchCreateChannelMembershipError&& value) { m_errors.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline BatchCreateChannelMembershipResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline BatchCreateChannelMembershipResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline BatchCreateChannelMembershipResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    BatchChannelMemberships m_batchChannelMemberships;

    Aws::Vector<BatchCreateChannelMembershipError> m_errors;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace ChimeSDKMessaging
} // namespace Aws
