﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/client/AWSError.h>
#include <aws/autoscaling-plans/AutoScalingPlansErrorMarshaller.h>
#include <aws/autoscaling-plans/AutoScalingPlansErrors.h>

using namespace Aws::Client;
using namespace Aws::AutoScalingPlans;

AWSError<CoreErrors> AutoScalingPlansErrorMarshaller::FindErrorByName(const char* errorName) const
{
  AWSError<CoreErrors> error = AutoScalingPlansErrorMapper::GetErrorForName(errorName);
  if(error.GetErrorType() != CoreErrors::UNKNOWN)
  {
    return error;
  }

  return AWSErrorMarshaller::FindErrorByName(errorName);
}