﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appfabric/AppFabric_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/appfabric/model/IngestionSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace AppFabric
{
namespace Model
{
  class ListIngestionsResult
  {
  public:
    AWS_APPFABRIC_API ListIngestionsResult();
    AWS_APPFABRIC_API ListIngestionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_APPFABRIC_API ListIngestionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>Contains a list of ingestion summaries.</p>
     */
    inline const Aws::Vector<IngestionSummary>& GetIngestions() const{ return m_ingestions; }
    inline void SetIngestions(const Aws::Vector<IngestionSummary>& value) { m_ingestions = value; }
    inline void SetIngestions(Aws::Vector<IngestionSummary>&& value) { m_ingestions = std::move(value); }
    inline ListIngestionsResult& WithIngestions(const Aws::Vector<IngestionSummary>& value) { SetIngestions(value); return *this;}
    inline ListIngestionsResult& WithIngestions(Aws::Vector<IngestionSummary>&& value) { SetIngestions(std::move(value)); return *this;}
    inline ListIngestionsResult& AddIngestions(const IngestionSummary& value) { m_ingestions.push_back(value); return *this; }
    inline ListIngestionsResult& AddIngestions(IngestionSummary&& value) { m_ingestions.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>If <code>nextToken</code> is returned, there are more results available. The
     * value of <code>nextToken</code> is a unique pagination token for each page. Make
     * the call again using the returned token to retrieve the next page. Keep all
     * other arguments unchanged. Each pagination token expires after 24 hours. Using
     * an expired pagination token will return an <i>HTTP 400 InvalidToken
     * error</i>.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListIngestionsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListIngestionsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListIngestionsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListIngestionsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListIngestionsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListIngestionsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<IngestionSummary> m_ingestions;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace AppFabric
} // namespace Aws
