﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/athena/model/WorkGroupSummary.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace Athena
{
namespace Model
{

WorkGroupSummary::WorkGroupSummary() : 
    m_nameHasBeenSet(false),
    m_state(WorkGroupState::NOT_SET),
    m_stateHasBeenSet(false),
    m_descriptionHasBeenSet(false),
    m_creationTimeHasBeenSet(false),
    m_engineVersionHasBeenSet(false),
    m_identityCenterApplicationArnHasBeenSet(false)
{
}

WorkGroupSummary::WorkGroupSummary(JsonView jsonValue) : 
    m_nameHasBeenSet(false),
    m_state(WorkGroupState::NOT_SET),
    m_stateHasBeenSet(false),
    m_descriptionHasBeenSet(false),
    m_creationTimeHasBeenSet(false),
    m_engineVersionHasBeenSet(false),
    m_identityCenterApplicationArnHasBeenSet(false)
{
  *this = jsonValue;
}

WorkGroupSummary& WorkGroupSummary::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Name"))
  {
    m_name = jsonValue.GetString("Name");

    m_nameHasBeenSet = true;
  }

  if(jsonValue.ValueExists("State"))
  {
    m_state = WorkGroupStateMapper::GetWorkGroupStateForName(jsonValue.GetString("State"));

    m_stateHasBeenSet = true;
  }

  if(jsonValue.ValueExists("Description"))
  {
    m_description = jsonValue.GetString("Description");

    m_descriptionHasBeenSet = true;
  }

  if(jsonValue.ValueExists("CreationTime"))
  {
    m_creationTime = jsonValue.GetDouble("CreationTime");

    m_creationTimeHasBeenSet = true;
  }

  if(jsonValue.ValueExists("EngineVersion"))
  {
    m_engineVersion = jsonValue.GetObject("EngineVersion");

    m_engineVersionHasBeenSet = true;
  }

  if(jsonValue.ValueExists("IdentityCenterApplicationArn"))
  {
    m_identityCenterApplicationArn = jsonValue.GetString("IdentityCenterApplicationArn");

    m_identityCenterApplicationArnHasBeenSet = true;
  }

  return *this;
}

JsonValue WorkGroupSummary::Jsonize() const
{
  JsonValue payload;

  if(m_nameHasBeenSet)
  {
   payload.WithString("Name", m_name);

  }

  if(m_stateHasBeenSet)
  {
   payload.WithString("State", WorkGroupStateMapper::GetNameForWorkGroupState(m_state));
  }

  if(m_descriptionHasBeenSet)
  {
   payload.WithString("Description", m_description);

  }

  if(m_creationTimeHasBeenSet)
  {
   payload.WithDouble("CreationTime", m_creationTime.SecondsWithMSPrecision());
  }

  if(m_engineVersionHasBeenSet)
  {
   payload.WithObject("EngineVersion", m_engineVersion.Jsonize());

  }

  if(m_identityCenterApplicationArnHasBeenSet)
  {
   payload.WithString("IdentityCenterApplicationArn", m_identityCenterApplicationArn);

  }

  return payload;
}

} // namespace Model
} // namespace Athena
} // namespace Aws
