/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import java.io.ByteArrayOutputStream;
import org.jruby.EvalType;
import org.jruby.ParseResult;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.api.Access;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.IRTranslator;
import org.jruby.ir.builder.IRBuilder;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.persistence.IRDumper;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class Interpreter
extends IRTranslator<IRubyObject, IRubyObject> {
    public static final Logger LOG = LoggerFactory.getLogger(Interpreter.class);
    public static final String ROOT = "<main>";
    static int interpInstrsCount = 0;

    public static void dumpStats() {
        if ((IRRuntimeHelpers.isDebug() || IRRuntimeHelpers.inProfileMode()) && interpInstrsCount > 10000) {
            LOG.info("-- Interpreted instructions: {}", interpInstrsCount);
        }
    }

    @Override
    protected IRubyObject execute(ThreadContext context, IRScriptBody irScope, IRubyObject self2) {
        StaticScope scope;
        RubyModule currModule;
        InterpreterContext ic = irScope.getInterpreterContext();
        if (IRRuntimeHelpers.shouldPrintIR(context.runtime) && IRRuntimeHelpers.shouldPrintScope(irScope)) {
            ByteArrayOutputStream baos = IRDumper.printIR(irScope, false);
            LOG.info("Printing simple IR for " + irScope.getId() + ":\n" + new String(baos.toByteArray()), new Object[0]);
        }
        String name2 = ROOT;
        if (IRRuntimeHelpers.isDebug()) {
            LOG.info("Executing {}", ic);
        }
        if ((currModule = (scope = ic.getStaticScope()).getModule()) == null) {
            currModule = Access.objectClass(context);
        }
        scope.setModule(currModule);
        IRRuntimeHelpers.prepareScriptScope(context, scope);
        context.preNodeEval(self2);
        context.setCurrentVisibility(Visibility.PRIVATE);
        try {
            IRubyObject iRubyObject = Interpreter.INTERPRET_ROOT(context, self2, ic, currModule, name2);
            return iRubyObject;
        }
        catch (IRBreakJump bj) {
            throw IRException.BREAK_LocalJumpError.getException(context.runtime);
        }
        finally {
            irScope.cleanupAfterExecution();
            Interpreter.dumpStats();
            context.popScope();
            context.postNodeEval();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_ROOT(ThreadContext context, IRubyObject self2, InterpreterContext ic, RubyModule clazz, String name2) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), ic.getLine());
            IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, clazz, name2, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_EVAL(ThreadContext context, IRubyObject self2, InterpreterContext ic, RubyModule clazz, IRubyObject[] args2, String name2, Block blockArg) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), ic.getLine());
            IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, clazz, name2, args2, blockArg);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_BLOCK(ThreadContext context, Block block, IRubyObject self2, InterpreterContext ic, IRubyObject[] args2, String name2, Block blockArg) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), ic.getLine());
            IRubyObject iRubyObject = ic.getEngine().interpret(context, block, self2, ic, null, name2, args2, blockArg);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    public static IRubyObject INTERPRET_CLASS(ThreadContext context, IRScope body, RubyModule clazz, String name2) {
        return Interpreter.interpretFrameScope(context, null, body, clazz, null, Visibility.PUBLIC, clazz, null, name2, null, Block.NULL_BLOCK);
    }

    public static IRubyObject INTERPRET_MODULE(ThreadContext context, IRScope body, RubyModule clazz, String name2) {
        return Interpreter.interpretFrameScope(context, null, body, clazz, null, Visibility.PUBLIC, clazz, null, name2, null, Block.NULL_BLOCK);
    }

    public static IRubyObject INTERPRET_METACLASS(ThreadContext context, IRScope body, RubyModule clazz, String name2, Visibility visibility) {
        return Interpreter.interpretFrameScope(context, null, body, clazz, context.getCurrentScope(), visibility, clazz, null, name2, null, Block.NULL_BLOCK);
    }

    public static IRubyObject INTERPRET_METHOD(ThreadContext context, IRScope body, RubyModule implClass, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        return Interpreter.interpretFrameScope(context, null, body, implClass, null, Visibility.PUBLIC, self2, name2, name2, args2, block);
    }

    public static IRubyObject INTERPRET_METHOD(ThreadContext context, IRScope body, RubyModule implClass, IRubyObject self2, String name2, Block block) {
        return Interpreter.interpretFrameScope(context, null, body, implClass, null, Visibility.PUBLIC, self2, name2, name2, IRubyObject.NULL_ARRAY, block);
    }

    public static IRubyObject INTERPRET_METHOD(ThreadContext context, IRScope body, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg0, Block block) {
        return Interpreter.interpretFrameScope(context, null, body, implClass, null, Visibility.PUBLIC, self2, name2, name2, Helpers.arrayOf(arg0), block);
    }

    public static IRubyObject INTERPRET_METHOD(ThreadContext context, IRScope body, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return Interpreter.interpretFrameScope(context, null, body, implClass, null, Visibility.PUBLIC, self2, name2, name2, Helpers.arrayOf(arg0, arg1), block);
    }

    public static IRubyObject INTERPRET_METHOD(ThreadContext context, IRScope body, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return Interpreter.interpretFrameScope(context, null, body, implClass, null, Visibility.PUBLIC, self2, name2, name2, Helpers.arrayOf(arg0, arg1, arg2), block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject interpretFrameScope(ThreadContext context, Block selfBlock, IRScope body, RubyModule clazz, DynamicScope parentScope, Visibility visibility, IRubyObject self2, String frameName, String passedName, IRubyObject[] args2, Block block) {
        InterpreterContext ic = body.getInterpreterContext();
        String id2 = body.getId();
        boolean hasExplicitCallProtocol = ic.hasExplicitCallProtocol();
        try {
            IRubyObject iRubyObject;
            block8: {
                ThreadContext.pushBacktrace(context, id2, ic.getFileName(), ic.getLine());
                if (!hasExplicitCallProtocol) {
                    Interpreter.preFrameScope(ic, context, self2, frameName, block, clazz, parentScope, visibility);
                }
                try {
                    iRubyObject = ic.getEngine().interpret(context, selfBlock, self2, ic, clazz, passedName, args2, block);
                    body.cleanupAfterExecution();
                    if (hasExplicitCallProtocol) break block8;
                }
                catch (Throwable throwable) {
                    body.cleanupAfterExecution();
                    if (!hasExplicitCallProtocol) {
                        Interpreter.postFrameScope(ic, context);
                    }
                    throw throwable;
                }
                Interpreter.postFrameScope(ic, context);
            }
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    public static void postFrameScope(InterpreterContext ic, ThreadContext context) {
        context.popFrame();
        if (ic.popDynScope()) {
            context.popScope();
        }
    }

    public static void preFrameScope(InterpreterContext ic, ThreadContext context, IRubyObject self2, String name2, Block block, RubyModule implClass, DynamicScope parentScope, Visibility visibility) {
        context.preMethodFrameOnly(implClass, name2, self2, visibility, block);
        if (ic.pushNewDynScope()) {
            if (parentScope == null) {
                context.pushScope(DynamicScope.newDynamicScope(ic.getStaticScope()));
            } else {
                context.pushScope(DynamicScope.newDynamicScope(ic.getStaticScope(), context.getCurrentScope()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject evalSimple(ThreadContext context, RubyModule under, IRubyObject self2, RubyString src, String file2, int lineNumber, EvalType evalType) {
        Ruby runtime2 = context.runtime;
        DynamicScope parentScope = context.getCurrentScope();
        ManyVarsDynamicScope evalScope = new ManyVarsDynamicScope(runtime2.getStaticScopeFactory().newEvalScope(parentScope.getStaticScope()), parentScope);
        evalScope.getStaticScope().setModule(under);
        context.pushEvalSimpleFrame(self2);
        try {
            IRubyObject iRubyObject = Interpreter.evalCommon(context, evalScope, self2, src, file2, lineNumber, Interpreter.evalName(file2, lineNumber), Block.NULL_BLOCK, evalType, false);
            return iRubyObject;
        }
        finally {
            context.popFrame();
        }
    }

    public static String evalName(String file2, int line) {
        return "(eval at " + file2 + ":" + line + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject evalCommon(ThreadContext context, DynamicScope evalScope, IRubyObject self2, IRubyObject src, String file2, int lineNumber, String name2, Block blockArg, EvalType evalType, boolean bindingGiven) {
        InterpreterContext ic = Interpreter.prepareIC(context, evalScope, src, file2, lineNumber, evalType, bindingGiven);
        evalScope.setEvalType(evalType);
        context.pushScope(evalScope);
        try {
            evalScope.growIfNeeded();
            IRubyObject iRubyObject = Interpreter.INTERPRET_EVAL(context, self2, ic, ic.getStaticScope().getModule(), IRubyObject.NULL_ARRAY, name2, blockArg);
            return iRubyObject;
        }
        finally {
            evalScope.clearEvalType();
            context.popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject evalWithBinding(ThreadContext context, IRubyObject self2, IRubyObject src, Binding binding2, boolean bindingGiven) {
        Ruby runtime2 = context.runtime;
        DynamicScope evalScope = binding2.getEvalScope(runtime2);
        evalScope.getStaticScope().setFile(binding2.getFile());
        evalScope.getStaticScope().determineModule();
        Frame lastFrame = context.preEvalWithBinding(binding2);
        try {
            IRubyObject iRubyObject = Interpreter.evalCommon(context, evalScope, self2, src, binding2.getFile(), binding2.getLine(), binding2.getMethod(), binding2.getFrame().getBlock(), EvalType.BINDING_EVAL, bindingGiven);
            return iRubyObject;
        }
        finally {
            context.postEvalWithBinding(binding2, lastFrame);
        }
    }

    private static InterpreterContext prepareIC(ThreadContext context, DynamicScope evalScope, IRubyObject src, String file2, int lineNumber, EvalType evalType, boolean bindingGiven) {
        Ruby runtime2 = context.runtime;
        IRScope containingIRScope = evalScope.getStaticScope().getEnclosingScope().getIRScope();
        ParseResult result2 = runtime2.getParserManager().parseEval(file2, lineNumber, src.convertToString().getByteList(), evalScope);
        StaticScope staticScope = evalScope.getStaticScope();
        IREvalScript script = new IREvalScript(runtime2.getIRManager(), containingIRScope, file2, lineNumber, staticScope, evalType);
        if (staticScope.getOverlayModuleForRead() != null || containingIRScope.maybeUsingRefinements()) {
            script.setIsMaybeUsingRefinements();
        }
        staticScope.setIRScope(script);
        IRManager manager = runtime2.getIRManager();
        IRBuilder builder = manager.getBuilderFactory().newIRBuilder(manager, script, null, result2.getEncoding());
        builder.evalType = !bindingGiven && evalType == EvalType.BINDING_EVAL ? EvalType.INSTANCE_EVAL : evalType;
        InterpreterContext ic = builder.buildEvalRoot(result2);
        if (IRRuntimeHelpers.isDebug()) {
            LOG.info(script.debugOutput(), new Object[0]);
        }
        return ic;
    }
}

