/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.warmup;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.core.ui.warmup.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class MenuWarmUpTask
implements Runnable {
    private Component[] comps;

    @Override
    public void run() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Frame frame = WindowManager.getDefault().getMainWindow();
                    assert (frame != null);
                    frame.addWindowListener(new NbWindowsAdapter());
                    if (frame instanceof JFrame) {
                        MenuWarmUpTask.access$102(MenuWarmUpTask.this, ((JFrame)frame).getJMenuBar().getComponents());
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (Exception exception) {
            return;
        }
        if (this.comps != null) {
            this.walkMenu(this.comps);
            this.comps = null;
        }
    }

    private void walkMenu(Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenu)) continue;
            try {
                Class<?> clazz = componentArray[i].getClass();
                Method method = clazz.getDeclaredMethod("doInitialize", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)componentArray[i], new Object[0]);
                this.walkMenu(((JMenu)componentArray[i]).getMenuComponents());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Component[] access$102(MenuWarmUpTask menuWarmUpTask, Component[] componentArray) {
        menuWarmUpTask.comps = componentArray;
        return componentArray;
    }

    private static class NbWindowsAdapter
    extends WindowAdapter
    implements Runnable,
    Cancellable {
        private static final RequestProcessor rp = new RequestProcessor("Refresh-After-WindowActivated", 1, true);
        private RequestProcessor.Task task;
        private AtomicBoolean goOn;
        private static final Logger UILOG = Logger.getLogger("org.netbeans.ui.focus");
        private static final Logger LOG = Logger.getLogger("org.netbeans.core.ui.focus");
        private boolean warnedNoRefresh;
        private int counter;

        private NbWindowsAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowActivated(WindowEvent windowEvent) {
            if (windowEvent.getOppositeWindow() == null) {
                RequestProcessor requestProcessor = rp;
                synchronized (requestProcessor) {
                    if (this.task != null) {
                        LOG.fine("Scheduling task after activation");
                        this.task.schedule(1500);
                        this.task = null;
                    } else {
                        LOG.fine("Activation without prepared refresh task");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            if (windowEvent.getOppositeWindow() == null) {
                Object object = rp;
                synchronized (object) {
                    if (this.task != null) {
                        this.task.cancel();
                    } else {
                        this.task = rp.create((Runnable)this);
                    }
                    LOG.fine("Window deactivated, preparing refresh task");
                }
                if (UILOG.isLoggable(Level.FINE)) {
                    object = new LogRecord(Level.FINE, "LOG_WINDOW_DEACTIVATED");
                    ((LogRecord)object).setResourceBundleName("org.netbeans.core.ui.warmup.Bundle");
                    ((LogRecord)object).setResourceBundle(NbBundle.getBundle(MenuWarmUpTask.class));
                    ((LogRecord)object).setLoggerName(UILOG.getName());
                    UILOG.log((LogRecord)object);
                }
            }
        }

        private static boolean isNoRefresh() {
            if (Boolean.getBoolean("netbeans.indexing.noFileRefresh")) {
                return true;
            }
            return NbPreferences.root().node("org/openide/actions/FileSystemRefreshAction").getBoolean("manual", false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (NbWindowsAdapter.isNoRefresh()) {
                if (!this.warnedNoRefresh) {
                    LOG.info("External Changes Refresh on focus gain disabled");
                    this.warnedNoRefresh = true;
                }
                LOG.fine("Refresh disabled, aborting");
                return;
            }
            final ProgressHandle progressHandle = ProgressHandle.createHandle((String)Bundle.MSG_Refresh(), (Cancellable)this, null);
            if (!LOG.isLoggable(Level.FINE)) {
                int n = Integer.parseInt(Bundle.MSG_RefreshDelay());
                progressHandle.setInitialDelay(n);
            }
            progressHandle.start();
            Runnable runnable = null;
            class HandleBridge
            extends ActionEvent
            implements Runnable {
                private FileObject previous;
                private long next;

                public HandleBridge(Object object) {
                    super(object, 0, "");
                }

                @Override
                public void setSource(Object object) {
                    if (object instanceof Object[]) {
                        long l = System.currentTimeMillis();
                        boolean bl = l > this.next;
                        Object[] objectArray = (Object[])object;
                        if (objectArray.length >= 3 && objectArray[0] instanceof Integer && objectArray[1] instanceof Integer && objectArray[2] instanceof FileObject) {
                            FileObject fileObject;
                            if (!(this.getSource() instanceof Object[])) {
                                progressHandle.switchToDeterminate(((Integer)objectArray[1]).intValue());
                                LOG.log(Level.FINE, "First refresh progress event delivered: {0}/{1} where {2}, goOn: {3}", objectArray);
                            }
                            if ((Integer)objectArray[0] < (Integer)objectArray[1]) {
                                progressHandle.progress(((Integer)objectArray[0]).intValue());
                            }
                            if (this.previous != (fileObject = (FileObject)objectArray[2]).getParent() && bl) {
                                this.previous = fileObject.getParent();
                                if (this.previous != null) {
                                    progressHandle.progress(this.previous.getPath());
                                }
                                this.next = l + 500L;
                            }
                            super.setSource(object);
                        }
                        if (objectArray.length >= 4 && objectArray[3] instanceof AtomicBoolean) {
                            NbWindowsAdapter.this.goOn = (AtomicBoolean)objectArray[3];
                        }
                        if (objectArray.length >= 5 && objectArray[4] == null && bl) {
                            objectArray[4] = Utilities.actionsGlobalContext().lookup(FileObject.class);
                            LOG.log(Level.FINE, "Preferring {0}", objectArray[4]);
                        }
                    }
                }

                @Override
                public void run() {
                    if (EventQueue.isDispatchThread()) {
                        try {
                            progressHandle.suspend(Bundle.MSG_Refresh_Suspend());
                        }
                        catch (Throwable throwable) {}
                    } else {
                        EventQueue.invokeLater(this);
                    }
                }
            }
            HandleBridge handleBridge = new HandleBridge(this);
            handleBridge.run();
            try {
                FileObject fileObject = FileUtil.toFileObject((File)Places.getUserDirectory());
                if (fileObject != null) {
                    fileObject = fileObject.getFileSystem().getRoot();
                }
                if (fileObject != null) {
                    runnable = (Runnable)fileObject.getAttribute("refreshSlow");
                }
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "Error getting refreshSlow", exception);
            }
            long l = System.currentTimeMillis();
            try {
                Serializable serializable;
                if (runnable == null) {
                    LOG.fine("Starting classical refresh");
                    FileUtil.refreshAll();
                } else {
                    if (runnable instanceof AtomicBoolean) {
                        this.goOn = (AtomicBoolean)((Object)runnable);
                        LOG.fine("goOn controller registered");
                    }
                    LOG.fine("Starting slow refresh");
                    runnable.equals(handleBridge);
                    runnable.run();
                }
                long l2 = System.currentTimeMillis() - l;
                if (UILOG.isLoggable(Level.FINE)) {
                    serializable = new LogRecord(Level.FINE, "LOG_WINDOW_ACTIVATED");
                    ((LogRecord)serializable).setParameters(new Object[]{l2});
                    ((LogRecord)serializable).setResourceBundleName("org.netbeans.core.ui.warmup.Bundle");
                    ((LogRecord)serializable).setResourceBundle(NbBundle.getBundle(MenuWarmUpTask.class));
                    ((LogRecord)serializable).setLoggerName(UILOG.getName());
                    UILOG.log((LogRecord)serializable);
                }
                LOG.log(Level.FINE, "Refresh done in {0} ms", l2);
                serializable = this.goOn;
                if (serializable == null || ((AtomicBoolean)serializable).get()) {
                    long l3 = System.currentTimeMillis();
                    FileUtil.getConfigRoot().getFileSystem().refresh(true);
                    LOG.log(Level.FINE, "SystemFileSystem refresh done {0} ms", System.currentTimeMillis() - l3);
                } else {
                    LOG.fine("Skipping SystemFileSystem refresh");
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
            finally {
                progressHandle.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            Object object = rp;
            synchronized (object) {
                if (this.task != null) {
                    this.task.cancel();
                }
                if (this.goOn != null) {
                    this.goOn.set(false);
                    LOG.log(Level.FINE, "Signaling cancel to {0}", System.identityHashCode(this.goOn));
                } else {
                    LOG.log(Level.FINE, "Cannot signal cancel, goOn is null");
                }
            }
            ++this.counter;
            if (UILOG.isLoggable(Level.FINE)) {
                object = new LogRecord(Level.FINE, "LOG_WINDOW_REFRESH_CANCEL");
                ((LogRecord)object).setParameters(new Object[]{this.counter});
                ((LogRecord)object).setResourceBundleName("org.netbeans.core.ui.warmup.Bundle");
                ((LogRecord)object).setResourceBundle(NbBundle.getBundle(MenuWarmUpTask.class));
                ((LogRecord)object).setLoggerName(UILOG.getName());
                UILOG.log((LogRecord)object);
            }
            return true;
        }
    }
}

