from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

ICELANDIC_LANG_MODEL = {
    36: {  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.LIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.LIKELY,  # 'L'
        38: SequenceLikelihood.LIKELY,  # 'M'
        47: SequenceLikelihood.LIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.LIKELY,  # 'R'
        31: SequenceLikelihood.LIKELY,  # 'S'
        45: SequenceLikelihood.LIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.LIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    39: {  # 'B'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.LIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.LIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.LIKELY,  # 'í'
        10: SequenceLikelihood.NEGATIVE,  # 'ð'
        23: SequenceLikelihood.LIKELY,  # 'ó'
        28: SequenceLikelihood.LIKELY,  # 'ö'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    55: {  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.LIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.NEGATIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    51: {  # 'D'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.LIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    35: {  # 'E'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.LIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.LIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.LIKELY,  # 'R'
        31: SequenceLikelihood.LIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        24: SequenceLikelihood.LIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.NEGATIVE,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    40: {  # 'F'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.LIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.LIKELY,  # 'æ'
        30: SequenceLikelihood.LIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.NEGATIVE,  # 'ð'
        23: SequenceLikelihood.LIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    42: {  # 'G'
        36: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.LIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.LIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.LIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    33: {  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.LIKELY,  # 'æ'
        30: SequenceLikelihood.LIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.LIKELY,  # 'ó'
        28: SequenceLikelihood.LIKELY,  # 'ö'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    50: {  # 'I'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.LIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.LIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.LIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.LIKELY,  # 'R'
        31: SequenceLikelihood.LIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    53: {  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.POSITIVE,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    46: {  # 'K'
        36: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.LIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.LIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.LIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.LIKELY,  # 'í'
        10: SequenceLikelihood.NEGATIVE,  # 'ð'
        23: SequenceLikelihood.LIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    43: {  # 'L'
        36: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.LIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.LIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.LIKELY,  # 'í'
        10: SequenceLikelihood.NEGATIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.LIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    38: {  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.LIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.LIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.LIKELY,  # 'ó'
        28: SequenceLikelihood.LIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    47: {  # 'N'
        36: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.LIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.LIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.LIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.LIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        32: SequenceLikelihood.LIKELY,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    56: {  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.LIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.NEGATIVE,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    49: {  # 'P'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.LIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.NEGATIVE,  # 'ð'
        23: SequenceLikelihood.LIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    71: {  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.NEGATIVE,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.NEGATIVE,  # 'Þ'
        19: SequenceLikelihood.NEGATIVE,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.NEGATIVE,  # 'é'
        20: SequenceLikelihood.NEGATIVE,  # 'í'
        10: SequenceLikelihood.NEGATIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    44: {  # 'R'
        36: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.LIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.LIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.LIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    31: {  # 'S'
        36: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.LIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.LIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.LIKELY,  # 'S'
        45: SequenceLikelihood.LIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.LIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.LIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.LIKELY,  # 'æ'
        30: SequenceLikelihood.LIKELY,  # 'é'
        20: SequenceLikelihood.LIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.LIKELY,  # 'ó'
        28: SequenceLikelihood.LIKELY,  # 'ö'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        32: SequenceLikelihood.LIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    45: {  # 'T'
        36: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.LIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.LIKELY,  # 'ó'
        28: SequenceLikelihood.LIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    58: {  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.LIKELY,  # 'M'
        47: SequenceLikelihood.LIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.LIKELY,  # 'R'
        31: SequenceLikelihood.LIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.NEGATIVE,  # 'æ'
        30: SequenceLikelihood.NEGATIVE,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.NEGATIVE,  # 'ó'
        28: SequenceLikelihood.NEGATIVE,  # 'ö'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    41: {  # 'V'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.LIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.LIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    62: {  # 'W'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.NEGATIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    68: {  # 'X'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.NEGATIVE,  # 'æ'
        30: SequenceLikelihood.NEGATIVE,  # 'é'
        20: SequenceLikelihood.NEGATIVE,  # 'í'
        10: SequenceLikelihood.NEGATIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    64: {  # 'Y'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.NEGATIVE,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.NEGATIVE,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    70: {  # 'Z'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.NEGATIVE,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.NEGATIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    1: {  # 'a'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.POSITIVE,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.LIKELY,  # 'w'
        52: SequenceLikelihood.POSITIVE,  # 'x'
        24: SequenceLikelihood.LIKELY,  # 'y'
        60: SequenceLikelihood.LIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.LIKELY,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.LIKELY,  # 'þ'
    },
    25: {  # 'b'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.POSITIVE,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.NEGATIVE,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.POSITIVE,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.POSITIVE,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.POSITIVE,  # 'ó'
        28: SequenceLikelihood.POSITIVE,  # 'ö'
        29: SequenceLikelihood.POSITIVE,  # 'ú'
        32: SequenceLikelihood.LIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    37: {  # 'c'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.LIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.NEGATIVE,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    17: {  # 'd'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.LIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.POSITIVE,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.LIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.POSITIVE,  # 'ó'
        28: SequenceLikelihood.LIKELY,  # 'ö'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        32: SequenceLikelihood.LIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    5: {  # 'e'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.LIKELY,  # 'w'
        52: SequenceLikelihood.POSITIVE,  # 'x'
        24: SequenceLikelihood.POSITIVE,  # 'y'
        60: SequenceLikelihood.LIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.LIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    14: {  # 'f'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.POSITIVE,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.POSITIVE,  # 'á'
        27: SequenceLikelihood.POSITIVE,  # 'æ'
        30: SequenceLikelihood.POSITIVE,  # 'é'
        20: SequenceLikelihood.LIKELY,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.POSITIVE,  # 'ó'
        28: SequenceLikelihood.POSITIVE,  # 'ö'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.LIKELY,  # 'þ'
    },
    11: {  # 'g'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.LIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.POSITIVE,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.LIKELY,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.POSITIVE,  # 'ó'
        28: SequenceLikelihood.POSITIVE,  # 'ö'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    18: {  # 'h'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.LIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.POSITIVE,  # 'á'
        27: SequenceLikelihood.POSITIVE,  # 'æ'
        30: SequenceLikelihood.POSITIVE,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.POSITIVE,  # 'ó'
        28: SequenceLikelihood.POSITIVE,  # 'ö'
        29: SequenceLikelihood.POSITIVE,  # 'ú'
        32: SequenceLikelihood.LIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    4: {  # 'i'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.POSITIVE,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.LIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    22: {  # 'j'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.POSITIVE,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.POSITIVE,  # 'ó'
        28: SequenceLikelihood.POSITIVE,  # 'ö'
        29: SequenceLikelihood.POSITIVE,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    13: {  # 'k'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.POSITIVE,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.POSITIVE,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.LIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.POSITIVE,  # 'ó'
        28: SequenceLikelihood.POSITIVE,  # 'ö'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        32: SequenceLikelihood.POSITIVE,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    9: {  # 'l'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.POSITIVE,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.POSITIVE,  # 'á'
        27: SequenceLikelihood.POSITIVE,  # 'æ'
        30: SequenceLikelihood.LIKELY,  # 'é'
        20: SequenceLikelihood.POSITIVE,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.POSITIVE,  # 'ó'
        28: SequenceLikelihood.POSITIVE,  # 'ö'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        32: SequenceLikelihood.POSITIVE,  # 'ý'
        21: SequenceLikelihood.LIKELY,  # 'þ'
    },
    12: {  # 'm'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.POSITIVE,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.POSITIVE,  # 'á'
        27: SequenceLikelihood.POSITIVE,  # 'æ'
        30: SequenceLikelihood.POSITIVE,  # 'é'
        20: SequenceLikelihood.POSITIVE,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.POSITIVE,  # 'ó'
        28: SequenceLikelihood.POSITIVE,  # 'ö'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        32: SequenceLikelihood.LIKELY,  # 'ý'
        21: SequenceLikelihood.LIKELY,  # 'þ'
    },
    3: {  # 'n'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.POSITIVE,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.LIKELY,  # 'y'
        60: SequenceLikelihood.LIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.POSITIVE,  # 'á'
        27: SequenceLikelihood.POSITIVE,  # 'æ'
        30: SequenceLikelihood.LIKELY,  # 'é'
        20: SequenceLikelihood.POSITIVE,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.POSITIVE,  # 'ó'
        28: SequenceLikelihood.LIKELY,  # 'ö'
        29: SequenceLikelihood.POSITIVE,  # 'ú'
        32: SequenceLikelihood.POSITIVE,  # 'ý'
        21: SequenceLikelihood.LIKELY,  # 'þ'
    },
    15: {  # 'o'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.LIKELY,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        24: SequenceLikelihood.LIKELY,  # 'y'
        60: SequenceLikelihood.LIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    26: {  # 'p'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.LIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.NEGATIVE,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.LIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.LIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.LIKELY,  # 'ó'
        28: SequenceLikelihood.LIKELY,  # 'ö'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    66: {  # 'q'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.NEGATIVE,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.NEGATIVE,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.NEGATIVE,  # 'æ'
        30: SequenceLikelihood.NEGATIVE,  # 'é'
        20: SequenceLikelihood.NEGATIVE,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    2: {  # 'r'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.POSITIVE,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.POSITIVE,  # 'á'
        27: SequenceLikelihood.POSITIVE,  # 'æ'
        30: SequenceLikelihood.POSITIVE,  # 'é'
        20: SequenceLikelihood.POSITIVE,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.POSITIVE,  # 'ó'
        28: SequenceLikelihood.POSITIVE,  # 'ö'
        29: SequenceLikelihood.POSITIVE,  # 'ú'
        32: SequenceLikelihood.POSITIVE,  # 'ý'
        21: SequenceLikelihood.LIKELY,  # 'þ'
    },
    6: {  # 's'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.POSITIVE,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.POSITIVE,  # 'á'
        27: SequenceLikelihood.POSITIVE,  # 'æ'
        30: SequenceLikelihood.POSITIVE,  # 'é'
        20: SequenceLikelihood.POSITIVE,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.POSITIVE,  # 'ó'
        28: SequenceLikelihood.POSITIVE,  # 'ö'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        32: SequenceLikelihood.POSITIVE,  # 'ý'
        21: SequenceLikelihood.LIKELY,  # 'þ'
    },
    7: {  # 't'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.LIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.POSITIVE,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.POSITIVE,  # 'æ'
        30: SequenceLikelihood.LIKELY,  # 'é'
        20: SequenceLikelihood.POSITIVE,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.POSITIVE,  # 'ó'
        28: SequenceLikelihood.POSITIVE,  # 'ö'
        29: SequenceLikelihood.POSITIVE,  # 'ú'
        32: SequenceLikelihood.LIKELY,  # 'ý'
        21: SequenceLikelihood.LIKELY,  # 'þ'
    },
    8: {  # 'u'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.LIKELY,  # 'þ'
    },
    16: {  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.NEGATIVE,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.POSITIVE,  # 'æ'
        30: SequenceLikelihood.LIKELY,  # 'é'
        20: SequenceLikelihood.POSITIVE,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.LIKELY,  # 'ó'
        28: SequenceLikelihood.POSITIVE,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    54: {  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.LIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.NEGATIVE,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.NEGATIVE,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.NEGATIVE,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.NEGATIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    52: {  # 'x'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.NEGATIVE,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    24: {  # 'y'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    60: {  # 'z'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.LIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.NEGATIVE,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.NEGATIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    57: {  # 'Á'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.NEGATIVE,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.NEGATIVE,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.UNLIKELY,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        68: SequenceLikelihood.NEGATIVE,  # 'X'
        64: SequenceLikelihood.NEGATIVE,  # 'Y'
        70: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.NEGATIVE,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.NEGATIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.NEGATIVE,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.NEGATIVE,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.NEGATIVE,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.NEGATIVE,  # 'ó'
        28: SequenceLikelihood.NEGATIVE,  # 'ö'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    69: {  # 'Æ'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.NEGATIVE,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.NEGATIVE,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.NEGATIVE,  # 'Y'
        70: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.NEGATIVE,  # 'y'
        60: SequenceLikelihood.NEGATIVE,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.NEGATIVE,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.NEGATIVE,  # 'é'
        20: SequenceLikelihood.NEGATIVE,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.NEGATIVE,  # 'ó'
        28: SequenceLikelihood.NEGATIVE,  # 'ö'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    59: {  # 'É'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.NEGATIVE,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.NEGATIVE,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        68: SequenceLikelihood.NEGATIVE,  # 'X'
        64: SequenceLikelihood.NEGATIVE,  # 'Y'
        70: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.NEGATIVE,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.NEGATIVE,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        52: SequenceLikelihood.NEGATIVE,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.NEGATIVE,  # 'Þ'
        19: SequenceLikelihood.NEGATIVE,  # 'á'
        27: SequenceLikelihood.NEGATIVE,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.NEGATIVE,  # 'í'
        10: SequenceLikelihood.NEGATIVE,  # 'ð'
        23: SequenceLikelihood.NEGATIVE,  # 'ó'
        28: SequenceLikelihood.NEGATIVE,  # 'ö'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    48: {  # 'Í'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.LIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.NEGATIVE,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        52: SequenceLikelihood.NEGATIVE,  # 'x'
        24: SequenceLikelihood.NEGATIVE,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.NEGATIVE,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    67: {  # 'Ð'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.NEGATIVE,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.NEGATIVE,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.NEGATIVE,  # 'c'
        17: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.NEGATIVE,  # 'o'
        26: SequenceLikelihood.NEGATIVE,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        52: SequenceLikelihood.NEGATIVE,  # 'x'
        24: SequenceLikelihood.NEGATIVE,  # 'y'
        60: SequenceLikelihood.NEGATIVE,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.NEGATIVE,  # 'á'
        27: SequenceLikelihood.NEGATIVE,  # 'æ'
        30: SequenceLikelihood.NEGATIVE,  # 'é'
        20: SequenceLikelihood.NEGATIVE,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.NEGATIVE,  # 'ó'
        28: SequenceLikelihood.NEGATIVE,  # 'ö'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    61: {  # 'Ó'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.NEGATIVE,  # 'Y'
        70: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.NEGATIVE,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    63: {  # 'Ö'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.NEGATIVE,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.NEGATIVE,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.NEGATIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.NEGATIVE,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.NEGATIVE,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.NEGATIVE,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    65: {  # 'Ú'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.NEGATIVE,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.NEGATIVE,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.NEGATIVE,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.NEGATIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        52: SequenceLikelihood.NEGATIVE,  # 'x'
        24: SequenceLikelihood.NEGATIVE,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.NEGATIVE,  # 'á'
        27: SequenceLikelihood.NEGATIVE,  # 'æ'
        30: SequenceLikelihood.NEGATIVE,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.NEGATIVE,  # 'ó'
        28: SequenceLikelihood.NEGATIVE,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    72: {  # 'Ý'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.NEGATIVE,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.NEGATIVE,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.NEGATIVE,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.NEGATIVE,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        68: SequenceLikelihood.NEGATIVE,  # 'X'
        64: SequenceLikelihood.NEGATIVE,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.NEGATIVE,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.NEGATIVE,  # 'g'
        18: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.NEGATIVE,  # 'o'
        26: SequenceLikelihood.NEGATIVE,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        52: SequenceLikelihood.NEGATIVE,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.NEGATIVE,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.NEGATIVE,  # 'Þ'
        19: SequenceLikelihood.NEGATIVE,  # 'á'
        27: SequenceLikelihood.NEGATIVE,  # 'æ'
        30: SequenceLikelihood.NEGATIVE,  # 'é'
        20: SequenceLikelihood.NEGATIVE,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.NEGATIVE,  # 'ó'
        28: SequenceLikelihood.NEGATIVE,  # 'ö'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.NEGATIVE,  # 'þ'
    },
    34: {  # 'Þ'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.NEGATIVE,  # 'C'
        51: SequenceLikelihood.NEGATIVE,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        68: SequenceLikelihood.NEGATIVE,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.NEGATIVE,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.NEGATIVE,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.NEGATIVE,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.LIKELY,  # 'á'
        27: SequenceLikelihood.LIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.LIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        32: SequenceLikelihood.LIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    19: {  # 'á'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.NEGATIVE,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.NEGATIVE,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.NEGATIVE,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.UNLIKELY,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.LIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    27: {  # 'æ'
        36: SequenceLikelihood.NEGATIVE,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.NEGATIVE,  # 'D'
        35: SequenceLikelihood.NEGATIVE,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.NEGATIVE,  # 'Y'
        70: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.NEGATIVE,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.NEGATIVE,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    30: {  # 'é'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.NEGATIVE,  # 'C'
        51: SequenceLikelihood.NEGATIVE,  # 'D'
        35: SequenceLikelihood.NEGATIVE,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.NEGATIVE,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.NEGATIVE,  # 'N'
        56: SequenceLikelihood.NEGATIVE,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        68: SequenceLikelihood.NEGATIVE,  # 'X'
        64: SequenceLikelihood.NEGATIVE,  # 'Y'
        70: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.NEGATIVE,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.LIKELY,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    20: {  # 'í'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.NEGATIVE,  # 'X'
        64: SequenceLikelihood.NEGATIVE,  # 'Y'
        70: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.UNLIKELY,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.LIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.LIKELY,  # 'þ'
    },
    10: {  # 'ð'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.UNLIKELY,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.UNLIKELY,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    23: {  # 'ó'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.NEGATIVE,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.NEGATIVE,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.NEGATIVE,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.NEGATIVE,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        25: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.LIKELY,  # 'þ'
    },
    28: {  # 'ö'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.NEGATIVE,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.NEGATIVE,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        68: SequenceLikelihood.NEGATIVE,  # 'X'
        64: SequenceLikelihood.NEGATIVE,  # 'Y'
        70: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.UNLIKELY,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.NEGATIVE,  # 'æ'
        30: SequenceLikelihood.UNLIKELY,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.NEGATIVE,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    29: {  # 'ú'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.UNLIKELY,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.NEGATIVE,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.NEGATIVE,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.UNLIKELY,  # 'K'
        43: SequenceLikelihood.UNLIKELY,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.NEGATIVE,  # 'O'
        49: SequenceLikelihood.NEGATIVE,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        68: SequenceLikelihood.NEGATIVE,  # 'X'
        64: SequenceLikelihood.NEGATIVE,  # 'Y'
        70: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.UNLIKELY,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.NEGATIVE,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    32: {  # 'ý'
        36: SequenceLikelihood.NEGATIVE,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.NEGATIVE,  # 'C'
        51: SequenceLikelihood.UNLIKELY,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        42: SequenceLikelihood.UNLIKELY,  # 'G'
        33: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.NEGATIVE,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        46: SequenceLikelihood.NEGATIVE,  # 'K'
        43: SequenceLikelihood.NEGATIVE,  # 'L'
        38: SequenceLikelihood.UNLIKELY,  # 'M'
        47: SequenceLikelihood.UNLIKELY,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.UNLIKELY,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.UNLIKELY,  # 'T'
        58: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        68: SequenceLikelihood.NEGATIVE,  # 'X'
        64: SequenceLikelihood.NEGATIVE,  # 'Y'
        70: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        22: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        24: SequenceLikelihood.UNLIKELY,  # 'y'
        60: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.NEGATIVE,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.NEGATIVE,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.NEGATIVE,  # 'Þ'
        19: SequenceLikelihood.UNLIKELY,  # 'á'
        27: SequenceLikelihood.UNLIKELY,  # 'æ'
        30: SequenceLikelihood.NEGATIVE,  # 'é'
        20: SequenceLikelihood.UNLIKELY,  # 'í'
        10: SequenceLikelihood.POSITIVE,  # 'ð'
        23: SequenceLikelihood.UNLIKELY,  # 'ó'
        28: SequenceLikelihood.UNLIKELY,  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        32: SequenceLikelihood.UNLIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
    21: {  # 'þ'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        55: SequenceLikelihood.NEGATIVE,  # 'C'
        51: SequenceLikelihood.NEGATIVE,  # 'D'
        35: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.NEGATIVE,  # 'F'
        42: SequenceLikelihood.NEGATIVE,  # 'G'
        33: SequenceLikelihood.NEGATIVE,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.NEGATIVE,  # 'J'
        46: SequenceLikelihood.NEGATIVE,  # 'K'
        43: SequenceLikelihood.NEGATIVE,  # 'L'
        38: SequenceLikelihood.NEGATIVE,  # 'M'
        47: SequenceLikelihood.NEGATIVE,  # 'N'
        56: SequenceLikelihood.UNLIKELY,  # 'O'
        49: SequenceLikelihood.NEGATIVE,  # 'P'
        71: SequenceLikelihood.NEGATIVE,  # 'Q'
        44: SequenceLikelihood.UNLIKELY,  # 'R'
        31: SequenceLikelihood.UNLIKELY,  # 'S'
        45: SequenceLikelihood.NEGATIVE,  # 'T'
        58: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        68: SequenceLikelihood.NEGATIVE,  # 'X'
        64: SequenceLikelihood.UNLIKELY,  # 'Y'
        70: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        14: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        22: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.NEGATIVE,  # 'x'
        24: SequenceLikelihood.POSITIVE,  # 'y'
        60: SequenceLikelihood.NEGATIVE,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Á'
        69: SequenceLikelihood.NEGATIVE,  # 'Æ'
        59: SequenceLikelihood.NEGATIVE,  # 'É'
        48: SequenceLikelihood.UNLIKELY,  # 'Í'
        67: SequenceLikelihood.NEGATIVE,  # 'Ð'
        61: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ö'
        65: SequenceLikelihood.UNLIKELY,  # 'Ú'
        72: SequenceLikelihood.NEGATIVE,  # 'Ý'
        34: SequenceLikelihood.NEGATIVE,  # 'Þ'
        19: SequenceLikelihood.POSITIVE,  # 'á'
        27: SequenceLikelihood.POSITIVE,  # 'æ'
        30: SequenceLikelihood.POSITIVE,  # 'é'
        20: SequenceLikelihood.LIKELY,  # 'í'
        10: SequenceLikelihood.UNLIKELY,  # 'ð'
        23: SequenceLikelihood.POSITIVE,  # 'ó'
        28: SequenceLikelihood.LIKELY,  # 'ö'
        29: SequenceLikelihood.POSITIVE,  # 'ú'
        32: SequenceLikelihood.LIKELY,  # 'ý'
        21: SequenceLikelihood.UNLIKELY,  # 'þ'
    },
}

# Character Mapping Table(s):
CP037_ICELANDIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 0,  # 'â'
    67: 0,  # 'ä'
    68: 0,  # 'à'
    69: 19,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 0,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '¢'
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '|'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 30,  # 'é'
    82: 0,  # 'ê'
    83: 0,  # 'ë'
    84: 0,  # 'è'
    85: 20,  # 'í'
    86: 0,  # 'î'
    87: 0,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # '!'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '¬'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 0,  # 'Â'
    99: 0,  # 'Ä'
    100: 0,  # 'À'
    101: 57,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 0,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 59,  # 'É'
    114: 0,  # 'Ê'
    115: 0,  # 'Ë'
    116: 0,  # 'È'
    117: 48,  # 'Í'
    118: 0,  # 'Î'
    119: 0,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 1,  # 'a'
    130: 25,  # 'b'
    131: 37,  # 'c'
    132: 17,  # 'd'
    133: 5,  # 'e'
    134: 14,  # 'f'
    135: 11,  # 'g'
    136: 18,  # 'h'
    137: 4,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 10,  # 'ð'
    141: 32,  # 'ý'
    142: 21,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 22,  # 'j'
    146: 13,  # 'k'
    147: 9,  # 'l'
    148: 12,  # 'm'
    149: 3,  # 'n'
    150: 15,  # 'o'
    151: 26,  # 'p'
    152: 66,  # 'q'
    153: 2,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 27,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 69,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 6,  # 's'
    163: 7,  # 't'
    164: 8,  # 'u'
    165: 16,  # 'v'
    166: 54,  # 'w'
    167: 52,  # 'x'
    168: 24,  # 'y'
    169: 60,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 67,  # 'Ð'
    173: 72,  # 'Ý'
    174: 34,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '^'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '['
    187: CharacterCategory.SYMBOL,  # ']'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 36,  # 'A'
    194: 39,  # 'B'
    195: 55,  # 'C'
    196: 51,  # 'D'
    197: 35,  # 'E'
    198: 40,  # 'F'
    199: 42,  # 'G'
    200: 33,  # 'H'
    201: 50,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 0,  # 'ô'
    204: 28,  # 'ö'
    205: 0,  # 'ò'
    206: 23,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 53,  # 'J'
    210: 46,  # 'K'
    211: 43,  # 'L'
    212: 38,  # 'M'
    213: 47,  # 'N'
    214: 56,  # 'O'
    215: 49,  # 'P'
    216: 71,  # 'Q'
    217: 44,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 0,  # 'û'
    220: 0,  # 'ü'
    221: 0,  # 'ù'
    222: 29,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 31,  # 'S'
    227: 45,  # 'T'
    228: 58,  # 'U'
    229: 41,  # 'V'
    230: 62,  # 'W'
    231: 68,  # 'X'
    232: 64,  # 'Y'
    233: 70,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 0,  # 'Ô'
    236: 63,  # 'Ö'
    237: 0,  # 'Ò'
    238: 61,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 0,  # 'Û'
    252: 0,  # 'Ü'
    253: 0,  # 'Ù'
    254: 65,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP037_ICELANDIC_MODEL = SingleByteCharSetModel(
    charset_name="CP037",
    language="Icelandic",
    char_to_order_map=CP037_ICELANDIC_CHAR_TO_ORDER,
    language_model=ICELANDIC_LANG_MODEL,
    typical_positive_ratio=0.9580323119536847,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÆÉÍÐÓÖÚÝÞáæéíðóöúýþ",
)

CP437_ICELANDIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 36,  # 'A'
    66: 39,  # 'B'
    67: 55,  # 'C'
    68: 51,  # 'D'
    69: 35,  # 'E'
    70: 40,  # 'F'
    71: 42,  # 'G'
    72: 33,  # 'H'
    73: 50,  # 'I'
    74: 53,  # 'J'
    75: 46,  # 'K'
    76: 43,  # 'L'
    77: 38,  # 'M'
    78: 47,  # 'N'
    79: 56,  # 'O'
    80: 49,  # 'P'
    81: 71,  # 'Q'
    82: 44,  # 'R'
    83: 31,  # 'S'
    84: 45,  # 'T'
    85: 58,  # 'U'
    86: 41,  # 'V'
    87: 62,  # 'W'
    88: 68,  # 'X'
    89: 64,  # 'Y'
    90: 70,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 25,  # 'b'
    99: 37,  # 'c'
    100: 17,  # 'd'
    101: 5,  # 'e'
    102: 14,  # 'f'
    103: 11,  # 'g'
    104: 18,  # 'h'
    105: 4,  # 'i'
    106: 22,  # 'j'
    107: 13,  # 'k'
    108: 9,  # 'l'
    109: 12,  # 'm'
    110: 3,  # 'n'
    111: 15,  # 'o'
    112: 26,  # 'p'
    113: 66,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 7,  # 't'
    117: 8,  # 'u'
    118: 16,  # 'v'
    119: 54,  # 'w'
    120: 52,  # 'x'
    121: 24,  # 'y'
    122: 60,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 30,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 59,  # 'É'
    145: 27,  # 'æ'
    146: 69,  # 'Æ'
    147: 0,  # 'ô'
    148: 28,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 63,  # 'Ö'
    154: 0,  # 'Ü'
    155: CharacterCategory.SYMBOL,  # '¢'
    156: CharacterCategory.SYMBOL,  # '£'
    157: CharacterCategory.SYMBOL,  # '¥'
    158: CharacterCategory.SYMBOL,  # '₧'
    159: 0,  # 'ƒ'
    160: 19,  # 'á'
    161: 20,  # 'í'
    162: 23,  # 'ó'
    163: 29,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '⌐'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP437_ICELANDIC_MODEL = SingleByteCharSetModel(
    charset_name="CP437",
    language="Icelandic",
    char_to_order_map=CP437_ICELANDIC_CHAR_TO_ORDER,
    language_model=ICELANDIC_LANG_MODEL,
    typical_positive_ratio=0.9592174724089144,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÆÉÍÐÓÖÚÝÞáæéíðóöúýþ",
)

CP500_ICELANDIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 0,  # 'â'
    67: 0,  # 'ä'
    68: 0,  # 'à'
    69: 19,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 0,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '['
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '!'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 30,  # 'é'
    82: 0,  # 'ê'
    83: 0,  # 'ë'
    84: 0,  # 'è'
    85: 20,  # 'í'
    86: 0,  # 'î'
    87: 0,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # ']'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '^'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 0,  # 'Â'
    99: 0,  # 'Ä'
    100: 0,  # 'À'
    101: 57,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 0,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 59,  # 'É'
    114: 0,  # 'Ê'
    115: 0,  # 'Ë'
    116: 0,  # 'È'
    117: 48,  # 'Í'
    118: 0,  # 'Î'
    119: 0,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 1,  # 'a'
    130: 25,  # 'b'
    131: 37,  # 'c'
    132: 17,  # 'd'
    133: 5,  # 'e'
    134: 14,  # 'f'
    135: 11,  # 'g'
    136: 18,  # 'h'
    137: 4,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 10,  # 'ð'
    141: 32,  # 'ý'
    142: 21,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 22,  # 'j'
    146: 13,  # 'k'
    147: 9,  # 'l'
    148: 12,  # 'm'
    149: 3,  # 'n'
    150: 15,  # 'o'
    151: 26,  # 'p'
    152: 66,  # 'q'
    153: 2,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 27,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 69,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 6,  # 's'
    163: 7,  # 't'
    164: 8,  # 'u'
    165: 16,  # 'v'
    166: 54,  # 'w'
    167: 52,  # 'x'
    168: 24,  # 'y'
    169: 60,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 67,  # 'Ð'
    173: 72,  # 'Ý'
    174: 34,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '¢'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '¬'
    187: CharacterCategory.SYMBOL,  # '|'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 36,  # 'A'
    194: 39,  # 'B'
    195: 55,  # 'C'
    196: 51,  # 'D'
    197: 35,  # 'E'
    198: 40,  # 'F'
    199: 42,  # 'G'
    200: 33,  # 'H'
    201: 50,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 0,  # 'ô'
    204: 28,  # 'ö'
    205: 0,  # 'ò'
    206: 23,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 53,  # 'J'
    210: 46,  # 'K'
    211: 43,  # 'L'
    212: 38,  # 'M'
    213: 47,  # 'N'
    214: 56,  # 'O'
    215: 49,  # 'P'
    216: 71,  # 'Q'
    217: 44,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 0,  # 'û'
    220: 0,  # 'ü'
    221: 0,  # 'ù'
    222: 29,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 31,  # 'S'
    227: 45,  # 'T'
    228: 58,  # 'U'
    229: 41,  # 'V'
    230: 62,  # 'W'
    231: 68,  # 'X'
    232: 64,  # 'Y'
    233: 70,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 0,  # 'Ô'
    236: 63,  # 'Ö'
    237: 0,  # 'Ò'
    238: 61,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 0,  # 'Û'
    252: 0,  # 'Ü'
    253: 0,  # 'Ù'
    254: 65,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP500_ICELANDIC_MODEL = SingleByteCharSetModel(
    charset_name="CP500",
    language="Icelandic",
    char_to_order_map=CP500_ICELANDIC_CHAR_TO_ORDER,
    language_model=ICELANDIC_LANG_MODEL,
    typical_positive_ratio=0.9580323119536847,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÆÉÍÐÓÖÚÝÞáæéíðóöúýþ",
)

CP850_ICELANDIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 36,  # 'A'
    66: 39,  # 'B'
    67: 55,  # 'C'
    68: 51,  # 'D'
    69: 35,  # 'E'
    70: 40,  # 'F'
    71: 42,  # 'G'
    72: 33,  # 'H'
    73: 50,  # 'I'
    74: 53,  # 'J'
    75: 46,  # 'K'
    76: 43,  # 'L'
    77: 38,  # 'M'
    78: 47,  # 'N'
    79: 56,  # 'O'
    80: 49,  # 'P'
    81: 71,  # 'Q'
    82: 44,  # 'R'
    83: 31,  # 'S'
    84: 45,  # 'T'
    85: 58,  # 'U'
    86: 41,  # 'V'
    87: 62,  # 'W'
    88: 68,  # 'X'
    89: 64,  # 'Y'
    90: 70,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 25,  # 'b'
    99: 37,  # 'c'
    100: 17,  # 'd'
    101: 5,  # 'e'
    102: 14,  # 'f'
    103: 11,  # 'g'
    104: 18,  # 'h'
    105: 4,  # 'i'
    106: 22,  # 'j'
    107: 13,  # 'k'
    108: 9,  # 'l'
    109: 12,  # 'm'
    110: 3,  # 'n'
    111: 15,  # 'o'
    112: 26,  # 'p'
    113: 66,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 7,  # 't'
    117: 8,  # 'u'
    118: 16,  # 'v'
    119: 54,  # 'w'
    120: 52,  # 'x'
    121: 24,  # 'y'
    122: 60,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 30,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 59,  # 'É'
    145: 27,  # 'æ'
    146: 69,  # 'Æ'
    147: 0,  # 'ô'
    148: 28,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 63,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 19,  # 'á'
    161: 20,  # 'í'
    162: 23,  # 'ó'
    163: 29,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 57,  # 'Á'
    182: 0,  # 'Â'
    183: 0,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 10,  # 'ð'
    209: 67,  # 'Ð'
    210: 0,  # 'Ê'
    211: 0,  # 'Ë'
    212: 0,  # 'È'
    213: 0,  # 'ı'
    214: 48,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 61,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 21,  # 'þ'
    232: 34,  # 'Þ'
    233: 65,  # 'Ú'
    234: 0,  # 'Û'
    235: 0,  # 'Ù'
    236: 32,  # 'ý'
    237: 72,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP850_ICELANDIC_MODEL = SingleByteCharSetModel(
    charset_name="CP850",
    language="Icelandic",
    char_to_order_map=CP850_ICELANDIC_CHAR_TO_ORDER,
    language_model=ICELANDIC_LANG_MODEL,
    typical_positive_ratio=0.9580323119536847,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÆÉÍÐÓÖÚÝÞáæéíðóöúýþ",
)

CP858_ICELANDIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 36,  # 'A'
    66: 39,  # 'B'
    67: 55,  # 'C'
    68: 51,  # 'D'
    69: 35,  # 'E'
    70: 40,  # 'F'
    71: 42,  # 'G'
    72: 33,  # 'H'
    73: 50,  # 'I'
    74: 53,  # 'J'
    75: 46,  # 'K'
    76: 43,  # 'L'
    77: 38,  # 'M'
    78: 47,  # 'N'
    79: 56,  # 'O'
    80: 49,  # 'P'
    81: 71,  # 'Q'
    82: 44,  # 'R'
    83: 31,  # 'S'
    84: 45,  # 'T'
    85: 58,  # 'U'
    86: 41,  # 'V'
    87: 62,  # 'W'
    88: 68,  # 'X'
    89: 64,  # 'Y'
    90: 70,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 25,  # 'b'
    99: 37,  # 'c'
    100: 17,  # 'd'
    101: 5,  # 'e'
    102: 14,  # 'f'
    103: 11,  # 'g'
    104: 18,  # 'h'
    105: 4,  # 'i'
    106: 22,  # 'j'
    107: 13,  # 'k'
    108: 9,  # 'l'
    109: 12,  # 'm'
    110: 3,  # 'n'
    111: 15,  # 'o'
    112: 26,  # 'p'
    113: 66,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 7,  # 't'
    117: 8,  # 'u'
    118: 16,  # 'v'
    119: 54,  # 'w'
    120: 52,  # 'x'
    121: 24,  # 'y'
    122: 60,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 30,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 59,  # 'É'
    145: 27,  # 'æ'
    146: 69,  # 'Æ'
    147: 0,  # 'ô'
    148: 28,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 63,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 19,  # 'á'
    161: 20,  # 'í'
    162: 23,  # 'ó'
    163: 29,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 57,  # 'Á'
    182: 0,  # 'Â'
    183: 0,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 10,  # 'ð'
    209: 67,  # 'Ð'
    210: 0,  # 'Ê'
    211: 0,  # 'Ë'
    212: 0,  # 'È'
    213: CharacterCategory.SYMBOL,  # '€'
    214: 48,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 61,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 21,  # 'þ'
    232: 34,  # 'Þ'
    233: 65,  # 'Ú'
    234: 0,  # 'Û'
    235: 0,  # 'Ù'
    236: 32,  # 'ý'
    237: 72,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP858_ICELANDIC_MODEL = SingleByteCharSetModel(
    charset_name="CP858",
    language="Icelandic",
    char_to_order_map=CP858_ICELANDIC_CHAR_TO_ORDER,
    language_model=ICELANDIC_LANG_MODEL,
    typical_positive_ratio=0.9580323119536847,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÆÉÍÐÓÖÚÝÞáæéíðóöúýþ",
)

CP861_ICELANDIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 36,  # 'A'
    66: 39,  # 'B'
    67: 55,  # 'C'
    68: 51,  # 'D'
    69: 35,  # 'E'
    70: 40,  # 'F'
    71: 42,  # 'G'
    72: 33,  # 'H'
    73: 50,  # 'I'
    74: 53,  # 'J'
    75: 46,  # 'K'
    76: 43,  # 'L'
    77: 38,  # 'M'
    78: 47,  # 'N'
    79: 56,  # 'O'
    80: 49,  # 'P'
    81: 71,  # 'Q'
    82: 44,  # 'R'
    83: 31,  # 'S'
    84: 45,  # 'T'
    85: 58,  # 'U'
    86: 41,  # 'V'
    87: 62,  # 'W'
    88: 68,  # 'X'
    89: 64,  # 'Y'
    90: 70,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 25,  # 'b'
    99: 37,  # 'c'
    100: 17,  # 'd'
    101: 5,  # 'e'
    102: 14,  # 'f'
    103: 11,  # 'g'
    104: 18,  # 'h'
    105: 4,  # 'i'
    106: 22,  # 'j'
    107: 13,  # 'k'
    108: 9,  # 'l'
    109: 12,  # 'm'
    110: 3,  # 'n'
    111: 15,  # 'o'
    112: 26,  # 'p'
    113: 66,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 7,  # 't'
    117: 8,  # 'u'
    118: 16,  # 'v'
    119: 54,  # 'w'
    120: 52,  # 'x'
    121: 24,  # 'y'
    122: 60,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 30,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 67,  # 'Ð'
    140: 10,  # 'ð'
    141: 34,  # 'Þ'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 59,  # 'É'
    145: 27,  # 'æ'
    146: 69,  # 'Æ'
    147: 0,  # 'ô'
    148: 28,  # 'ö'
    149: 21,  # 'þ'
    150: 0,  # 'û'
    151: 72,  # 'Ý'
    152: 32,  # 'ý'
    153: 63,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '₧'
    159: 0,  # 'ƒ'
    160: 19,  # 'á'
    161: 20,  # 'í'
    162: 23,  # 'ó'
    163: 29,  # 'ú'
    164: 57,  # 'Á'
    165: 48,  # 'Í'
    166: 61,  # 'Ó'
    167: 65,  # 'Ú'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '⌐'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP861_ICELANDIC_MODEL = SingleByteCharSetModel(
    charset_name="CP861",
    language="Icelandic",
    char_to_order_map=CP861_ICELANDIC_CHAR_TO_ORDER,
    language_model=ICELANDIC_LANG_MODEL,
    typical_positive_ratio=0.9580323119536847,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÆÉÍÐÓÖÚÝÞáæéíðóöúýþ",
)

ISO_8859_1_ICELANDIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 36,  # 'A'
    66: 39,  # 'B'
    67: 55,  # 'C'
    68: 51,  # 'D'
    69: 35,  # 'E'
    70: 40,  # 'F'
    71: 42,  # 'G'
    72: 33,  # 'H'
    73: 50,  # 'I'
    74: 53,  # 'J'
    75: 46,  # 'K'
    76: 43,  # 'L'
    77: 38,  # 'M'
    78: 47,  # 'N'
    79: 56,  # 'O'
    80: 49,  # 'P'
    81: 71,  # 'Q'
    82: 44,  # 'R'
    83: 31,  # 'S'
    84: 45,  # 'T'
    85: 58,  # 'U'
    86: 41,  # 'V'
    87: 62,  # 'W'
    88: 68,  # 'X'
    89: 64,  # 'Y'
    90: 70,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 25,  # 'b'
    99: 37,  # 'c'
    100: 17,  # 'd'
    101: 5,  # 'e'
    102: 14,  # 'f'
    103: 11,  # 'g'
    104: 18,  # 'h'
    105: 4,  # 'i'
    106: 22,  # 'j'
    107: 13,  # 'k'
    108: 9,  # 'l'
    109: 12,  # 'm'
    110: 3,  # 'n'
    111: 15,  # 'o'
    112: 26,  # 'p'
    113: 66,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 7,  # 't'
    117: 8,  # 'u'
    118: 16,  # 'v'
    119: 54,  # 'w'
    120: 52,  # 'x'
    121: 24,  # 'y'
    122: 60,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 57,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 69,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 59,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 48,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 67,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 61,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 63,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 65,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 72,  # 'Ý'
    222: 34,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 19,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 27,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 30,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 20,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 10,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 23,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 28,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 29,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 32,  # 'ý'
    254: 21,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_1_ICELANDIC_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-1",
    language="Icelandic",
    char_to_order_map=ISO_8859_1_ICELANDIC_CHAR_TO_ORDER,
    language_model=ICELANDIC_LANG_MODEL,
    typical_positive_ratio=0.9580323119536847,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÆÉÍÐÓÖÚÝÞáæéíðóöúýþ",
)

ISO_8859_10_ICELANDIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 36,  # 'A'
    66: 39,  # 'B'
    67: 55,  # 'C'
    68: 51,  # 'D'
    69: 35,  # 'E'
    70: 40,  # 'F'
    71: 42,  # 'G'
    72: 33,  # 'H'
    73: 50,  # 'I'
    74: 53,  # 'J'
    75: 46,  # 'K'
    76: 43,  # 'L'
    77: 38,  # 'M'
    78: 47,  # 'N'
    79: 56,  # 'O'
    80: 49,  # 'P'
    81: 71,  # 'Q'
    82: 44,  # 'R'
    83: 31,  # 'S'
    84: 45,  # 'T'
    85: 58,  # 'U'
    86: 41,  # 'V'
    87: 62,  # 'W'
    88: 68,  # 'X'
    89: 64,  # 'Y'
    90: 70,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 25,  # 'b'
    99: 37,  # 'c'
    100: 17,  # 'd'
    101: 5,  # 'e'
    102: 14,  # 'f'
    103: 11,  # 'g'
    104: 18,  # 'h'
    105: 4,  # 'i'
    106: 22,  # 'j'
    107: 13,  # 'k'
    108: 9,  # 'l'
    109: 12,  # 'm'
    110: 3,  # 'n'
    111: 15,  # 'o'
    112: 26,  # 'p'
    113: 66,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 7,  # 't'
    117: 8,  # 'u'
    118: 16,  # 'v'
    119: 54,  # 'w'
    120: 52,  # 'x'
    121: 24,  # 'y'
    122: 60,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ą'
    162: 0,  # 'Ē'
    163: 0,  # 'Ģ'
    164: 0,  # 'Ī'
    165: 0,  # 'Ĩ'
    166: 0,  # 'Ķ'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'Ļ'
    169: 0,  # 'Đ'
    170: 0,  # 'Š'
    171: 0,  # 'Ŧ'
    172: 0,  # 'Ž'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 0,  # 'Ū'
    175: 0,  # 'Ŋ'
    176: CharacterCategory.SYMBOL,  # '°'
    177: 0,  # 'ą'
    178: 0,  # 'ē'
    179: 0,  # 'ģ'
    180: 0,  # 'ī'
    181: 0,  # 'ĩ'
    182: 0,  # 'ķ'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ļ'
    185: 0,  # 'đ'
    186: 0,  # 'š'
    187: 0,  # 'ŧ'
    188: 0,  # 'ž'
    189: CharacterCategory.SYMBOL,  # '―'
    190: 0,  # 'ū'
    191: 0,  # 'ŋ'
    192: 0,  # 'Ā'
    193: 57,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 69,  # 'Æ'
    199: 0,  # 'Į'
    200: 0,  # 'Č'
    201: 59,  # 'É'
    202: 0,  # 'Ę'
    203: 0,  # 'Ë'
    204: 0,  # 'Ė'
    205: 48,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 67,  # 'Ð'
    209: 0,  # 'Ņ'
    210: 0,  # 'Ō'
    211: 61,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 63,  # 'Ö'
    215: 0,  # 'Ũ'
    216: 0,  # 'Ø'
    217: 0,  # 'Ų'
    218: 65,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 72,  # 'Ý'
    222: 34,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'ā'
    225: 19,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 27,  # 'æ'
    231: 0,  # 'į'
    232: 0,  # 'č'
    233: 30,  # 'é'
    234: 0,  # 'ę'
    235: 0,  # 'ë'
    236: 0,  # 'ė'
    237: 20,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 10,  # 'ð'
    241: 0,  # 'ņ'
    242: 0,  # 'ō'
    243: 23,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 28,  # 'ö'
    247: 0,  # 'ũ'
    248: 0,  # 'ø'
    249: 0,  # 'ų'
    250: 29,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 32,  # 'ý'
    254: 21,  # 'þ'
    255: 0,  # 'ĸ'
}

ISO_8859_10_ICELANDIC_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-10",
    language="Icelandic",
    char_to_order_map=ISO_8859_10_ICELANDIC_CHAR_TO_ORDER,
    language_model=ICELANDIC_LANG_MODEL,
    typical_positive_ratio=0.9580323119536847,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÆÉÍÐÓÖÚÝÞáæéíðóöúýþ",
)

ISO_8859_15_ICELANDIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 36,  # 'A'
    66: 39,  # 'B'
    67: 55,  # 'C'
    68: 51,  # 'D'
    69: 35,  # 'E'
    70: 40,  # 'F'
    71: 42,  # 'G'
    72: 33,  # 'H'
    73: 50,  # 'I'
    74: 53,  # 'J'
    75: 46,  # 'K'
    76: 43,  # 'L'
    77: 38,  # 'M'
    78: 47,  # 'N'
    79: 56,  # 'O'
    80: 49,  # 'P'
    81: 71,  # 'Q'
    82: 44,  # 'R'
    83: 31,  # 'S'
    84: 45,  # 'T'
    85: 58,  # 'U'
    86: 41,  # 'V'
    87: 62,  # 'W'
    88: 68,  # 'X'
    89: 64,  # 'Y'
    90: 70,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 25,  # 'b'
    99: 37,  # 'c'
    100: 17,  # 'd'
    101: 5,  # 'e'
    102: 14,  # 'f'
    103: 11,  # 'g'
    104: 18,  # 'h'
    105: 4,  # 'i'
    106: 22,  # 'j'
    107: 13,  # 'k'
    108: 9,  # 'l'
    109: 12,  # 'm'
    110: 3,  # 'n'
    111: 15,  # 'o'
    112: 26,  # 'p'
    113: 66,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 7,  # 't'
    117: 8,  # 'u'
    118: 16,  # 'v'
    119: 54,  # 'w'
    120: 52,  # 'x'
    121: 24,  # 'y'
    122: 60,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: 0,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: 0,  # 'Ž'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ž'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Œ'
    189: 0,  # 'œ'
    190: 0,  # 'Ÿ'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 57,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 69,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 59,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 48,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 67,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 61,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 63,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 65,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 72,  # 'Ý'
    222: 34,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 19,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 27,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 30,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 20,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 10,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 23,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 28,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 29,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 32,  # 'ý'
    254: 21,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_15_ICELANDIC_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-15",
    language="Icelandic",
    char_to_order_map=ISO_8859_15_ICELANDIC_CHAR_TO_ORDER,
    language_model=ICELANDIC_LANG_MODEL,
    typical_positive_ratio=0.9580323119536847,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÆÉÍÐÓÖÚÝÞáæéíðóöúýþ",
)

MACICELAND_ICELANDIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 36,  # 'A'
    66: 39,  # 'B'
    67: 55,  # 'C'
    68: 51,  # 'D'
    69: 35,  # 'E'
    70: 40,  # 'F'
    71: 42,  # 'G'
    72: 33,  # 'H'
    73: 50,  # 'I'
    74: 53,  # 'J'
    75: 46,  # 'K'
    76: 43,  # 'L'
    77: 38,  # 'M'
    78: 47,  # 'N'
    79: 56,  # 'O'
    80: 49,  # 'P'
    81: 71,  # 'Q'
    82: 44,  # 'R'
    83: 31,  # 'S'
    84: 45,  # 'T'
    85: 58,  # 'U'
    86: 41,  # 'V'
    87: 62,  # 'W'
    88: 68,  # 'X'
    89: 64,  # 'Y'
    90: 70,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 25,  # 'b'
    99: 37,  # 'c'
    100: 17,  # 'd'
    101: 5,  # 'e'
    102: 14,  # 'f'
    103: 11,  # 'g'
    104: 18,  # 'h'
    105: 4,  # 'i'
    106: 22,  # 'j'
    107: 13,  # 'k'
    108: 9,  # 'l'
    109: 12,  # 'm'
    110: 3,  # 'n'
    111: 15,  # 'o'
    112: 26,  # 'p'
    113: 66,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 7,  # 't'
    117: 8,  # 'u'
    118: 16,  # 'v'
    119: 54,  # 'w'
    120: 52,  # 'x'
    121: 24,  # 'y'
    122: 60,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Å'
    130: 0,  # 'Ç'
    131: 59,  # 'É'
    132: 0,  # 'Ñ'
    133: 63,  # 'Ö'
    134: 0,  # 'Ü'
    135: 19,  # 'á'
    136: 0,  # 'à'
    137: 0,  # 'â'
    138: 0,  # 'ä'
    139: 0,  # 'ã'
    140: 0,  # 'å'
    141: 0,  # 'ç'
    142: 30,  # 'é'
    143: 0,  # 'è'
    144: 0,  # 'ê'
    145: 0,  # 'ë'
    146: 20,  # 'í'
    147: 0,  # 'ì'
    148: 0,  # 'î'
    149: 0,  # 'ï'
    150: 0,  # 'ñ'
    151: 23,  # 'ó'
    152: 0,  # 'ò'
    153: 0,  # 'ô'
    154: 28,  # 'ö'
    155: 0,  # 'õ'
    156: 29,  # 'ú'
    157: 0,  # 'ù'
    158: 0,  # 'û'
    159: 0,  # 'ü'
    160: 72,  # 'Ý'
    161: CharacterCategory.SYMBOL,  # '°'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: CharacterCategory.SYMBOL,  # '´'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 69,  # 'Æ'
    175: 0,  # 'Ø'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: CharacterCategory.SYMBOL,  # '¥'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: CharacterCategory.SYMBOL,  # '∏'
    185: 0,  # 'π'
    186: CharacterCategory.SYMBOL,  # '∫'
    187: 0,  # 'ª'
    188: 0,  # 'º'
    189: 0,  # 'Ω'
    190: 27,  # 'æ'
    191: 0,  # 'ø'
    192: CharacterCategory.SYMBOL,  # '¿'
    193: CharacterCategory.SYMBOL,  # '¡'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'À'
    204: 0,  # 'Ã'
    205: 0,  # 'Õ'
    206: 0,  # 'Œ'
    207: 0,  # 'œ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ÿ'
    217: 0,  # 'Ÿ'
    218: CharacterCategory.SYMBOL,  # '⁄'
    219: CharacterCategory.SYMBOL,  # '€'
    220: 67,  # 'Ð'
    221: 10,  # 'ð'
    222: 34,  # 'Þ'
    223: 21,  # 'þ'
    224: 32,  # 'ý'
    225: CharacterCategory.SYMBOL,  # '·'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: CharacterCategory.SYMBOL,  # '‰'
    229: 0,  # 'Â'
    230: 0,  # 'Ê'
    231: 57,  # 'Á'
    232: 0,  # 'Ë'
    233: 0,  # 'È'
    234: 48,  # 'Í'
    235: 0,  # 'Î'
    236: 0,  # 'Ï'
    237: 0,  # 'Ì'
    238: 61,  # 'Ó'
    239: 0,  # 'Ô'
    240: CharacterCategory.CONTROL,  # '\uf8ff'
    241: 0,  # 'Ò'
    242: 65,  # 'Ú'
    243: 0,  # 'Û'
    244: 0,  # 'Ù'
    245: 0,  # 'ı'
    246: 0,  # 'ˆ'
    247: CharacterCategory.SYMBOL,  # '˜'
    248: CharacterCategory.SYMBOL,  # '¯'
    249: CharacterCategory.SYMBOL,  # '˘'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: CharacterCategory.SYMBOL,  # '˚'
    252: CharacterCategory.SYMBOL,  # '¸'
    253: CharacterCategory.SYMBOL,  # '˝'
    254: CharacterCategory.SYMBOL,  # '˛'
    255: 0,  # 'ˇ'
}

MACICELAND_ICELANDIC_MODEL = SingleByteCharSetModel(
    charset_name="MacIceland",
    language="Icelandic",
    char_to_order_map=MACICELAND_ICELANDIC_CHAR_TO_ORDER,
    language_model=ICELANDIC_LANG_MODEL,
    typical_positive_ratio=0.9580323119536847,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÆÉÍÐÓÖÚÝÞáæéíðóöúýþ",
)

MACROMAN_ICELANDIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 36,  # 'A'
    66: 39,  # 'B'
    67: 55,  # 'C'
    68: 51,  # 'D'
    69: 35,  # 'E'
    70: 40,  # 'F'
    71: 42,  # 'G'
    72: 33,  # 'H'
    73: 50,  # 'I'
    74: 53,  # 'J'
    75: 46,  # 'K'
    76: 43,  # 'L'
    77: 38,  # 'M'
    78: 47,  # 'N'
    79: 56,  # 'O'
    80: 49,  # 'P'
    81: 71,  # 'Q'
    82: 44,  # 'R'
    83: 31,  # 'S'
    84: 45,  # 'T'
    85: 58,  # 'U'
    86: 41,  # 'V'
    87: 62,  # 'W'
    88: 68,  # 'X'
    89: 64,  # 'Y'
    90: 70,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 25,  # 'b'
    99: 37,  # 'c'
    100: 17,  # 'd'
    101: 5,  # 'e'
    102: 14,  # 'f'
    103: 11,  # 'g'
    104: 18,  # 'h'
    105: 4,  # 'i'
    106: 22,  # 'j'
    107: 13,  # 'k'
    108: 9,  # 'l'
    109: 12,  # 'm'
    110: 3,  # 'n'
    111: 15,  # 'o'
    112: 26,  # 'p'
    113: 66,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 7,  # 't'
    117: 8,  # 'u'
    118: 16,  # 'v'
    119: 54,  # 'w'
    120: 52,  # 'x'
    121: 24,  # 'y'
    122: 60,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Å'
    130: 0,  # 'Ç'
    131: 59,  # 'É'
    132: 0,  # 'Ñ'
    133: 63,  # 'Ö'
    134: 0,  # 'Ü'
    135: 19,  # 'á'
    136: 0,  # 'à'
    137: 0,  # 'â'
    138: 0,  # 'ä'
    139: 0,  # 'ã'
    140: 0,  # 'å'
    141: 0,  # 'ç'
    142: 30,  # 'é'
    143: 0,  # 'è'
    144: 0,  # 'ê'
    145: 0,  # 'ë'
    146: 20,  # 'í'
    147: 0,  # 'ì'
    148: 0,  # 'î'
    149: 0,  # 'ï'
    150: 0,  # 'ñ'
    151: 23,  # 'ó'
    152: 0,  # 'ò'
    153: 0,  # 'ô'
    154: 28,  # 'ö'
    155: 0,  # 'õ'
    156: 29,  # 'ú'
    157: 0,  # 'ù'
    158: 0,  # 'û'
    159: 0,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: CharacterCategory.SYMBOL,  # '´'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 69,  # 'Æ'
    175: 0,  # 'Ø'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: CharacterCategory.SYMBOL,  # '¥'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: CharacterCategory.SYMBOL,  # '∏'
    185: 0,  # 'π'
    186: CharacterCategory.SYMBOL,  # '∫'
    187: 0,  # 'ª'
    188: 0,  # 'º'
    189: 0,  # 'Ω'
    190: 27,  # 'æ'
    191: 0,  # 'ø'
    192: CharacterCategory.SYMBOL,  # '¿'
    193: CharacterCategory.SYMBOL,  # '¡'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'À'
    204: 0,  # 'Ã'
    205: 0,  # 'Õ'
    206: 0,  # 'Œ'
    207: 0,  # 'œ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ÿ'
    217: 0,  # 'Ÿ'
    218: CharacterCategory.SYMBOL,  # '⁄'
    219: CharacterCategory.SYMBOL,  # '€'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ﬁ'
    223: 0,  # 'ﬂ'
    224: CharacterCategory.SYMBOL,  # '‡'
    225: CharacterCategory.SYMBOL,  # '·'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: CharacterCategory.SYMBOL,  # '‰'
    229: 0,  # 'Â'
    230: 0,  # 'Ê'
    231: 57,  # 'Á'
    232: 0,  # 'Ë'
    233: 0,  # 'È'
    234: 48,  # 'Í'
    235: 0,  # 'Î'
    236: 0,  # 'Ï'
    237: 0,  # 'Ì'
    238: 61,  # 'Ó'
    239: 0,  # 'Ô'
    240: CharacterCategory.CONTROL,  # '\uf8ff'
    241: 0,  # 'Ò'
    242: 65,  # 'Ú'
    243: 0,  # 'Û'
    244: 0,  # 'Ù'
    245: 0,  # 'ı'
    246: 0,  # 'ˆ'
    247: CharacterCategory.SYMBOL,  # '˜'
    248: CharacterCategory.SYMBOL,  # '¯'
    249: CharacterCategory.SYMBOL,  # '˘'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: CharacterCategory.SYMBOL,  # '˚'
    252: CharacterCategory.SYMBOL,  # '¸'
    253: CharacterCategory.SYMBOL,  # '˝'
    254: CharacterCategory.SYMBOL,  # '˛'
    255: 0,  # 'ˇ'
}

MACROMAN_ICELANDIC_MODEL = SingleByteCharSetModel(
    charset_name="MacRoman",
    language="Icelandic",
    char_to_order_map=MACROMAN_ICELANDIC_CHAR_TO_ORDER,
    language_model=ICELANDIC_LANG_MODEL,
    typical_positive_ratio=0.9580322077649689,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÆÉÍÐÓÖÚÝÞáæéíðóöúýþ",
)

WINDOWS_1252_ICELANDIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 36,  # 'A'
    66: 39,  # 'B'
    67: 55,  # 'C'
    68: 51,  # 'D'
    69: 35,  # 'E'
    70: 40,  # 'F'
    71: 42,  # 'G'
    72: 33,  # 'H'
    73: 50,  # 'I'
    74: 53,  # 'J'
    75: 46,  # 'K'
    76: 43,  # 'L'
    77: 38,  # 'M'
    78: 47,  # 'N'
    79: 56,  # 'O'
    80: 49,  # 'P'
    81: 71,  # 'Q'
    82: 44,  # 'R'
    83: 31,  # 'S'
    84: 45,  # 'T'
    85: 58,  # 'U'
    86: 41,  # 'V'
    87: 62,  # 'W'
    88: 68,  # 'X'
    89: 64,  # 'Y'
    90: 70,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 25,  # 'b'
    99: 37,  # 'c'
    100: 17,  # 'd'
    101: 5,  # 'e'
    102: 14,  # 'f'
    103: 11,  # 'g'
    104: 18,  # 'h'
    105: 4,  # 'i'
    106: 22,  # 'j'
    107: 13,  # 'k'
    108: 9,  # 'l'
    109: 12,  # 'm'
    110: 3,  # 'n'
    111: 15,  # 'o'
    112: 26,  # 'p'
    113: 66,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 7,  # 't'
    117: 8,  # 'u'
    118: 16,  # 'v'
    119: 54,  # 'w'
    120: 52,  # 'x'
    121: 24,  # 'y'
    122: 60,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: 0,  # 'ˆ'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Œ'
    141: CharacterCategory.UNDEFINED,  # None
    142: 0,  # 'Ž'
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.SYMBOL,  # '˜'
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'œ'
    157: CharacterCategory.UNDEFINED,  # None
    158: 0,  # 'ž'
    159: 0,  # 'Ÿ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 57,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 69,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 59,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 48,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 67,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 61,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 63,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 65,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 72,  # 'Ý'
    222: 34,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 19,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 27,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 30,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 20,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 10,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 23,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 28,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 29,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 32,  # 'ý'
    254: 21,  # 'þ'
    255: 0,  # 'ÿ'
}

WINDOWS_1252_ICELANDIC_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1252",
    language="Icelandic",
    char_to_order_map=WINDOWS_1252_ICELANDIC_CHAR_TO_ORDER,
    language_model=ICELANDIC_LANG_MODEL,
    typical_positive_ratio=0.9580323119536847,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÆÉÍÐÓÖÚÝÞáæéíðóöúýþ",
)
