/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.memory.NativeMemory;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.ResizeFactor;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.Util;
import java.nio.ByteOrder;

final class PreambleUtil {
    static final int PREAMBLE_LONGS_BYTE = 0;
    static final int LG_RESIZE_FACTOR_BIT = 6;
    static final int SER_VER_BYTE = 1;
    static final int FAMILY_BYTE = 2;
    static final int LG_NOM_LONGS_BYTE = 3;
    static final int LG_ARR_LONGS_BYTE = 4;
    static final int FLAGS_BYTE = 5;
    static final int SEED_HASH_SHORT = 6;
    static final int RETAINED_ENTRIES_INT = 8;
    static final int P_FLOAT = 12;
    static final int THETA_LONG = 16;
    static final int UNION_THETA_LONG = 24;
    static final int BIG_ENDIAN_FLAG_MASK = 1;
    static final int READ_ONLY_FLAG_MASK = 2;
    static final int EMPTY_FLAG_MASK = 4;
    static final int COMPACT_FLAG_MASK = 8;
    static final int ORDERED_FLAG_MASK = 16;
    static final int LG_RESIZE_RATIO_BYTE_V1 = 5;
    static final int FLAGS_BYTE_V1 = 6;
    static final int SER_VER = 3;
    static final boolean NATIVE_ORDER_IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    static final double MAX_THETA_LONG_AS_DOUBLE = 9.223372036854776E18;

    private PreambleUtil() {
    }

    static final int getMemBytes(int lgArrLongs, int preambleLongs) {
        return (8 << lgArrLongs) + (preambleLongs << 3);
    }

    public static String preambleToString(byte[] byteArr) {
        NativeMemory mem = new NativeMemory(byteArr);
        return PreambleUtil.preambleToString((Memory)mem);
    }

    public static String preambleToString(Memory mem) {
        long thetaLong;
        Object memObj = mem.array();
        long memAdd = mem.getCumulativeOffset(0L);
        int preLongs = PreambleUtil.getAndCheckPreLongs(memObj, memAdd, mem);
        ResizeFactor rf = ResizeFactor.getRF(PreambleUtil.extractLgResizeFactor(memObj, memAdd));
        int serVer = PreambleUtil.extractSerVer(memObj, memAdd);
        Family family = Family.idToFamily(PreambleUtil.extractFamilyID(memObj, memAdd));
        int lgNomLongs = PreambleUtil.extractLgNomLongs(memObj, memAdd);
        int lgArrLongs = PreambleUtil.extractLgArrLongs(memObj, memAdd);
        int flags = PreambleUtil.extractFlags(memObj, memAdd);
        String flagsStr = Util.zeroPad(Integer.toBinaryString(flags), 8) + ", " + flags;
        boolean bigEndian = (flags & 1) > 0;
        String nativeOrder = ByteOrder.nativeOrder().toString();
        boolean compact = (flags & 8) > 0;
        boolean ordered = (flags & 0x10) > 0;
        boolean readOnly = (flags & 2) > 0;
        boolean empty = (flags & 4) > 0;
        int seedHash = PreambleUtil.extractSeedHash(memObj, memAdd);
        int curCount = 0;
        float p = 1.0f;
        long thetaULong = thetaLong = (long)((double)p * 9.223372036854776E18);
        if (preLongs == 2) {
            curCount = PreambleUtil.extractCurCount(memObj, memAdd);
            p = PreambleUtil.extractP(memObj, memAdd);
            thetaULong = thetaLong = (long)((double)p * 9.223372036854776E18);
        } else if (preLongs == 3) {
            curCount = PreambleUtil.extractCurCount(memObj, memAdd);
            p = PreambleUtil.extractP(memObj, memAdd);
            thetaULong = thetaLong = PreambleUtil.extractThetaLong(memObj, memAdd);
        } else if (preLongs == 4) {
            curCount = PreambleUtil.extractCurCount(memObj, memAdd);
            p = PreambleUtil.extractP(memObj, memAdd);
            thetaLong = PreambleUtil.extractThetaLong(memObj, memAdd);
            thetaULong = PreambleUtil.extractUnionThetaLong(memObj, memAdd);
        }
        double thetaDbl = (double)thetaLong / 9.223372036854776E18;
        String thetaHex = Util.zeroPad(Long.toHexString(thetaLong), 16);
        double thetaUDbl = (double)thetaULong / 9.223372036854776E18;
        String thetaUHex = Util.zeroPad(Long.toHexString(thetaULong), 16);
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS).append("### SKETCH PREAMBLE SUMMARY:").append(Util.LS).append("Byte  0: Preamble Longs       : ").append(preLongs).append(Util.LS).append("Byte  0: ResizeFactor         : ").append(rf.toString()).append(Util.LS).append("Byte  1: Serialization Version: ").append(serVer).append(Util.LS).append("Byte  2: Family               : ").append(family.toString()).append(Util.LS).append("Byte  3: LgNomLongs           : ").append(lgNomLongs).append(Util.LS).append("Byte  4: LgArrLongs           : ").append(lgArrLongs).append(Util.LS).append("Byte  5: Flags Field          : ").append(flagsStr).append(Util.LS).append("  BIG_ENDIAN_STORAGE          : ").append(bigEndian).append(Util.LS).append("  (Native Byte Order)         : ").append(nativeOrder).append(Util.LS).append("  READ_ONLY                   : ").append(readOnly).append(Util.LS).append("  EMPTY                       : ").append(empty).append(Util.LS).append("  COMPACT                     : ").append(compact).append(Util.LS).append("  ORDERED                     : ").append(ordered).append(Util.LS).append("Bytes 6-7  : Seed Hash        : ").append(Integer.toHexString(seedHash)).append(Util.LS);
        if (preLongs == 1) {
            sb.append(" --ABSENT, ASSUMED:").append(Util.LS);
            sb.append("Bytes 8-11 : CurrentCount     : ").append(curCount).append(Util.LS).append("Bytes 12-15: P                : ").append(p).append(Util.LS);
            sb.append("Bytes 16-23: Theta (double)   : ").append(thetaDbl).append(Util.LS).append("             Theta (long)     : ").append(thetaLong).append(Util.LS).append("             Theta (long,hex) : ").append(thetaHex).append(Util.LS);
        }
        if (preLongs == 2) {
            sb.append("Bytes 8-11 : CurrentCount     : ").append(curCount).append(Util.LS).append("Bytes 12-15: P                : ").append(p).append(Util.LS);
            sb.append(" --ABSENT, ASSUMED:").append(Util.LS);
            sb.append("Bytes 16-23: Theta (double)   : ").append(thetaDbl).append(Util.LS).append("             Theta (long)     : ").append(thetaLong).append(Util.LS).append("             Theta (long,hex) : ").append(thetaHex).append(Util.LS);
        }
        if (preLongs == 3) {
            sb.append("Bytes 8-11 : CurrentCount     : ").append(curCount).append(Util.LS).append("Bytes 12-15: P                : ").append(p).append(Util.LS);
            sb.append("Bytes 16-23: Theta (double)   : ").append(thetaDbl).append(Util.LS).append("             Theta (long)     : ").append(thetaLong).append(Util.LS).append("             Theta (long,hex) : ").append(thetaHex).append(Util.LS);
        }
        if (preLongs == 4) {
            sb.append("Bytes 8-11 : CurrentCount     : ").append(curCount).append(Util.LS).append("Bytes 12-15: P                : ").append(p).append(Util.LS);
            sb.append("Bytes 16-23: Theta (double)   : ").append(thetaDbl).append(Util.LS).append("             Theta (long)     : ").append(thetaLong).append(Util.LS).append("             Theta (long,hex) : ").append(thetaHex).append(Util.LS);
            sb.append("Bytes 25-31: ThetaU (double)  : ").append(thetaUDbl).append(Util.LS).append("             ThetaU (long)    : ").append(thetaULong).append(Util.LS).append("             ThetaU (long,hex): ").append(thetaUHex).append(Util.LS);
        }
        sb.append("Preamble Bytes                : ").append(preLongs * 8).append(Util.LS);
        sb.append("Data Bytes                    : ").append(curCount * 8).append(Util.LS);
        sb.append("TOTAL Sketch Bytes            : ").append(mem.getCapacity()).append(Util.LS).append("### END SKETCH PREAMBLE SUMMARY").append(Util.LS);
        return sb.toString();
    }

    static int extractPreLongs(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getByte(memObj, memAdd + 0L) & 0x3F;
    }

    static int extractLgResizeFactor(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getByte(memObj, memAdd + 0L) >> 6 & 3;
    }

    static int extractLgResizeRatioV1(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getByte(memObj, memAdd + 5L) & 3;
    }

    static int extractSerVer(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getByte(memObj, memAdd + 1L) & 0xFF;
    }

    static int extractFamilyID(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getByte(memObj, memAdd + 2L) & 0xFF;
    }

    static int extractLgNomLongs(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getByte(memObj, memAdd + 3L) & 0xFF;
    }

    static int extractLgArrLongs(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getByte(memObj, memAdd + 4L) & 0xFF;
    }

    static int extractFlags(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getByte(memObj, memAdd + 5L) & 0xFF;
    }

    static int extractFlagsV1(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getByte(memObj, memAdd + 6L) & 0xFF;
    }

    static int extractSeedHash(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getShort(memObj, memAdd + 6L) & 0xFFFF;
    }

    static int extractCurCount(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getInt(memObj, memAdd + 8L);
    }

    static float extractP(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getFloat(memObj, memAdd + 12L);
    }

    static long extractThetaLong(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getLong(memObj, memAdd + 16L);
    }

    static long extractUnionThetaLong(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getLong(memObj, memAdd + 24L);
    }

    static void insertPreLongs(Object memObj, long memAdd, int preLongs) {
        UnsafeUtil.unsafe.putByte(memObj, memAdd + 0L, (byte)(preLongs & 0x3F));
    }

    static void insertLgResizeFactor(Object memObj, long memAdd, int rf) {
        byte curByte = UnsafeUtil.unsafe.getByte(memObj, memAdd + 0L);
        int shift = 6;
        int mask = 3;
        byte newByte = (byte)((rf & 3) << 6 | 0xFFFFFF3F & curByte);
        UnsafeUtil.unsafe.putByte(memObj, memAdd + 0L, newByte);
    }

    static void insertSerVer(Object memObj, long memAdd, int serVer) {
        UnsafeUtil.unsafe.putByte(memObj, memAdd + 1L, (byte)serVer);
    }

    static void insertFamilyID(Object memObj, long memAdd, int famId) {
        UnsafeUtil.unsafe.putByte(memObj, memAdd + 2L, (byte)famId);
    }

    static void insertLgNomLongs(Object memObj, long memAdd, int lgNomLongs) {
        UnsafeUtil.unsafe.putByte(memObj, memAdd + 3L, (byte)lgNomLongs);
    }

    static void insertLgArrLongs(Object memObj, long memAdd, int lgArrLongs) {
        UnsafeUtil.unsafe.putByte(memObj, memAdd + 4L, (byte)lgArrLongs);
    }

    static void insertFlags(Object memObj, long memAdd, int flags) {
        UnsafeUtil.unsafe.putByte(memObj, memAdd + 5L, (byte)flags);
    }

    static void insertSeedHash(Object memObj, long memAdd, int seedHash) {
        UnsafeUtil.unsafe.putShort(memObj, memAdd + 6L, (short)seedHash);
    }

    static void insertCurCount(Object memObj, long memAdd, int curCount) {
        UnsafeUtil.unsafe.putInt(memObj, memAdd + 8L, curCount);
    }

    static void insertP(Object memObj, long memAdd, float p) {
        UnsafeUtil.unsafe.putFloat(memObj, memAdd + 12L, p);
    }

    static void insertThetaLong(Object memObj, long memAdd, long thetaLong) {
        UnsafeUtil.unsafe.putLong(memObj, memAdd + 16L, thetaLong);
    }

    static void insertUnionThetaLong(Object memObj, long memAdd, long unionThetaLong) {
        UnsafeUtil.unsafe.putLong(memObj, memAdd + 24L, unionThetaLong);
    }

    static void setEmpty(Object memObj, long memAdd) {
        int flags = UnsafeUtil.unsafe.getByte(memObj, memAdd + 5L);
        UnsafeUtil.unsafe.putByte(memObj, memAdd + 5L, (byte)(flags |= 4));
    }

    static void clearEmpty(Object memObj, long memAdd) {
        int flags = UnsafeUtil.unsafe.getByte(memObj, memAdd + 5L);
        UnsafeUtil.unsafe.putByte(memObj, memAdd + 5L, (byte)(flags &= 0xFFFFFFFB));
    }

    static boolean isEmpty(Object memObj, long memAdd) {
        byte flags = UnsafeUtil.unsafe.getByte(memObj, memAdd + 5L);
        return (flags & 4) > 0;
    }

    static int getAndCheckPreLongs(Object memObj, long memAdd, Memory mem) {
        int preLongs;
        int required;
        long cap = mem.getCapacity();
        if (cap < 8L) {
            PreambleUtil.throwNotBigEnough(cap, 8);
        }
        if (cap < (long)(required = Math.max((preLongs = PreambleUtil.extractPreLongs(memObj, memAdd)) << 3, 8))) {
            PreambleUtil.throwNotBigEnough(cap, required);
        }
        return preLongs;
    }

    private static void throwNotBigEnough(long cap, int required) {
        throw new SketchesArgumentException("Possible Corruption: Size of byte array or Memory not large enough: Size: " + cap + ", Required: " + required);
    }
}

