/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.utils;

import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import java.net.URI;
import java.security.AccessController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.opensearch.sql.common.interceptors.AwsSigningInterceptor;
import org.opensearch.sql.common.interceptors.BasicAuthenticationInterceptor;
import org.opensearch.sql.common.interceptors.URIValidatorInterceptor;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.datasource.client.exceptions.DataSourceClientException;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasources.auth.AuthenticationType;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.client.PrometheusClientImpl;

public class PrometheusClientUtils {
    public static final String AUTH_TYPE = "prometheus.auth.type";
    public static final String USERNAME = "prometheus.auth.username";
    public static final String PASSWORD = "prometheus.auth.password";
    public static final String REGION = "prometheus.auth.region";
    public static final String ACCESS_KEY = "prometheus.auth.access_key";
    public static final String SECRET_KEY = "prometheus.auth.secret_key";
    public static final String PROMETHEUS_URI = "prometheus.uri";
    public static final String ALERTMANAGER_URI = "alertmanager.uri";
    public static final String ALERTMANAGER_AUTH_TYPE = "alertmanager.auth.type";
    public static final String ALERTMANAGER_USERNAME = "alertmanager.auth.username";
    public static final String ALERTMANAGER_PASSWORD = "alertmanager.auth.password";
    public static final String ALERTMANAGER_REGION = "alertmanager.auth.region";
    public static final String ALERTMANAGER_ACCESS_KEY = "alertmanager.auth.access_key";
    public static final String ALERTMANAGER_SECRET_KEY = "alertmanager.auth.secret_key";

    private PrometheusClientUtils() {
    }

    public static OkHttpClient getHttpClient(Map<String, String> config, Settings settings) {
        return AccessController.doPrivileged(() -> {
            OkHttpClient.Builder okHttpClient = new OkHttpClient.Builder();
            okHttpClient.callTimeout(1L, TimeUnit.MINUTES);
            okHttpClient.connectTimeout(30L, TimeUnit.SECONDS);
            okHttpClient.followRedirects(false);
            okHttpClient.addInterceptor(new URIValidatorInterceptor((List)settings.getSettingValue(Settings.Key.DATASOURCES_URI_HOSTS_DENY_LIST)));
            if (config.get(AUTH_TYPE) != null) {
                AuthenticationType authenticationType = AuthenticationType.get((String)config.get(AUTH_TYPE));
                if (AuthenticationType.BASICAUTH.equals((Object)authenticationType)) {
                    okHttpClient.addInterceptor(new BasicAuthenticationInterceptor((String)config.get(USERNAME), (String)config.get(PASSWORD)));
                } else if (AuthenticationType.AWSSIGV4AUTH.equals((Object)authenticationType)) {
                    okHttpClient.addInterceptor(new AwsSigningInterceptor(new AWSStaticCredentialsProvider(new BasicAWSCredentials((String)config.get(ACCESS_KEY), (String)config.get(SECRET_KEY))), (String)config.get(REGION), "aps"));
                } else {
                    throw new IllegalArgumentException(String.format("AUTH Type : %s is not supported with Prometheus Connector", config.get(AUTH_TYPE)));
                }
            }
            return okHttpClient.build();
        });
    }

    public static Map<String, String> createAlertmanagerProperties(Map<String, String> properties2) {
        HashMap<String, String> alertmanagerProperties = new HashMap<String, String>();
        if (properties2.containsKey(ALERTMANAGER_AUTH_TYPE)) {
            alertmanagerProperties.put(AUTH_TYPE, properties2.get(ALERTMANAGER_AUTH_TYPE));
            String authType = properties2.get(ALERTMANAGER_AUTH_TYPE);
            if (Objects.nonNull(authType)) {
                if (authType.equalsIgnoreCase("basicauth")) {
                    alertmanagerProperties.put(USERNAME, properties2.get(ALERTMANAGER_USERNAME));
                    alertmanagerProperties.put(PASSWORD, properties2.get(ALERTMANAGER_PASSWORD));
                } else if (authType.equalsIgnoreCase("awssigv4auth")) {
                    alertmanagerProperties.put(ACCESS_KEY, properties2.get(ALERTMANAGER_ACCESS_KEY));
                    alertmanagerProperties.put(SECRET_KEY, properties2.get(ALERTMANAGER_SECRET_KEY));
                    alertmanagerProperties.put(REGION, properties2.get(ALERTMANAGER_REGION));
                }
            }
        }
        return alertmanagerProperties;
    }

    public static boolean hasAlertmanagerConfig(Map<String, String> properties2) {
        return Objects.nonNull(properties2.get(ALERTMANAGER_URI));
    }

    public static PrometheusClient createPrometheusClient(DataSourceMetadata metadata2, Settings settings) {
        URI alertmanagerUri;
        OkHttpClient prometheusHttpClient;
        String host = metadata2.getProperties().get(PROMETHEUS_URI);
        if (Objects.isNull(host)) {
            throw new DataSourceClientException("Host is required for Prometheus data source");
        }
        URI uri = URI.create(host);
        Map<String, String> properties2 = metadata2.getProperties();
        OkHttpClient alertmanagerHttpClient = prometheusHttpClient = PrometheusClientUtils.getHttpClient(properties2, settings);
        if (PrometheusClientUtils.hasAlertmanagerConfig(properties2)) {
            String alertmanagerHost = properties2.get(ALERTMANAGER_URI);
            alertmanagerUri = URI.create(alertmanagerHost);
            Map<String, String> alertmanagerProperties = PrometheusClientUtils.createAlertmanagerProperties(properties2);
            if (!alertmanagerProperties.isEmpty()) {
                alertmanagerHttpClient = PrometheusClientUtils.getHttpClient(alertmanagerProperties, settings);
            }
        } else {
            alertmanagerUri = URI.create(host.replaceAll("/$", "") + "/alertmanager");
        }
        return new PrometheusClientImpl(prometheusHttpClient, uri, alertmanagerHttpClient, alertmanagerUri);
    }
}

