/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.aggregation.dsl;

import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.MultiTermsAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.support.MultiTermsValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValueType;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.span.SpanExpression;
import org.opensearch.sql.opensearch.data.type.OpenSearchDateType;
import org.opensearch.sql.opensearch.storage.script.aggregation.dsl.AggregationBuilderHelper;
import org.opensearch.sql.opensearch.storage.serde.ExpressionSerializer;

public class BucketAggregationBuilder {
    private final AggregationBuilderHelper helper;

    public BucketAggregationBuilder(ExpressionSerializer serializer) {
        this.helper = new AggregationBuilderHelper(serializer);
    }

    public ValuesSourceAggregationBuilder<?> build(NamedExpression expr) {
        if (expr.getDelegated() instanceof SpanExpression) {
            SpanExpression spanExpr = (SpanExpression)expr.getDelegated();
            return BucketAggregationBuilder.buildHistogram(expr.getName(), spanExpr.getField().toString(), spanExpr.getValue().valueOf().doubleValue(), spanExpr.getUnit());
        }
        TermsAggregationBuilder sourceBuilder = new TermsAggregationBuilder(expr.getName());
        sourceBuilder.size(1000);
        sourceBuilder.order(BucketOrder.key((boolean)true));
        if (expr.getDelegated().type() instanceof OpenSearchDateType && List.of(ExprCoreType.TIMESTAMP, ExprCoreType.TIME, ExprCoreType.DATE).contains(((OpenSearchDateType)expr.getDelegated().type()).getExprCoreType()) || List.of(ExprCoreType.TIMESTAMP, ExprCoreType.TIME, ExprCoreType.DATE).contains(expr.getDelegated().type())) {
            sourceBuilder.userValueTypeHint(ValueType.LONG);
        }
        return (ValuesSourceAggregationBuilder)this.helper.build(expr.getDelegated(), arg_0 -> ((TermsAggregationBuilder)sourceBuilder).field(arg_0), arg_0 -> ((TermsAggregationBuilder)sourceBuilder).script(arg_0));
    }

    public MultiTermsAggregationBuilder buildMultipleTerms(List<NamedExpression> exprs) {
        MultiTermsAggregationBuilder sourceBuilder = new MultiTermsAggregationBuilder(exprs.stream().map(NamedExpression::getName).collect(Collectors.joining("_")));
        sourceBuilder.terms(exprs.stream().map(expr -> {
            MultiTermsValuesSourceConfig.Builder config = new MultiTermsValuesSourceConfig.Builder();
            config.setFieldName(expr.getName());
            if (expr.getDelegated().type() instanceof OpenSearchDateType && List.of(ExprCoreType.TIMESTAMP, ExprCoreType.TIME, ExprCoreType.DATE).contains(((OpenSearchDateType)expr.getDelegated().type()).getExprCoreType()) || List.of(ExprCoreType.TIMESTAMP, ExprCoreType.TIME, ExprCoreType.DATE).contains(expr.getDelegated().type())) {
                config.setUserValueTypeHint(ValueType.LONG);
            }
            return config.build();
        }).toList());
        sourceBuilder.size(1000);
        return sourceBuilder;
    }

    public static ValuesSourceAggregationBuilder<?> buildHistogram(String name, String field, Double value, SpanUnit unit) {
        switch (unit) {
            case NONE: {
                return ((HistogramAggregationBuilder)new HistogramAggregationBuilder(name).field(field)).interval(value.doubleValue());
            }
            case UNKNOWN: {
                throw new IllegalStateException("Invalid span unit");
            }
        }
        return BucketAggregationBuilder.buildDateHistogram(name, field, value.intValue(), unit);
    }

    public static ValuesSourceAggregationBuilder<?> buildAutoDateHistogram(String name, String field, Integer bucketSize) {
        return ((AutoDateHistogramAggregationBuilder)new AutoDateHistogramAggregationBuilder(name).field(field)).setNumBuckets(bucketSize.intValue());
    }

    public static ValuesSourceAggregationBuilder<?> buildDateHistogram(String name, String field, Integer value, SpanUnit unit) {
        String spanValue = value + unit.getName();
        switch (unit) {
            case MILLISECOND: 
            case MS: 
            case SECOND: 
            case S: 
            case MINUTE: 
            case m: 
            case HOUR: 
            case H: 
            case DAY: 
            case D: {
                return ((DateHistogramAggregationBuilder)new DateHistogramAggregationBuilder(name).field(field)).fixedInterval(new DateHistogramInterval(spanValue));
            }
        }
        return ((DateHistogramAggregationBuilder)new DateHistogramAggregationBuilder(name).field(field)).calendarInterval(new DateHistogramInterval(spanValue));
    }
}

