/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.response.agg;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.search.SearchHit;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.metrics.TopHits;
import org.opensearch.sql.opensearch.response.agg.MetricParser;

public class TopHitsParser
implements MetricParser {
    private final String name;
    private final boolean returnSingleValue;

    public TopHitsParser(String name) {
        this.name = name;
        this.returnSingleValue = false;
    }

    public TopHitsParser(String name, boolean returnSingleValue) {
        this.name = name;
        this.returnSingleValue = returnSingleValue;
    }

    @Override
    public Map<String, Object> parse(Aggregation agg) {
        TopHits topHits = (TopHits)agg;
        SearchHit[] hits = topHits.getHits().getHits();
        if (hits.length == 0) {
            return Collections.singletonMap(agg.getName(), null);
        }
        if (this.returnSingleValue) {
            Map source2 = hits[0].getSourceAsMap();
            if (source2.isEmpty()) {
                return Collections.singletonMap(agg.getName(), null);
            }
            Object value = source2.values().iterator().next();
            return Collections.singletonMap(agg.getName(), value);
        }
        return Collections.singletonMap(agg.getName(), Arrays.stream(hits).flatMap(h2 -> h2.getSourceAsMap().values().stream()).collect(Collectors.toList()));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopHitsParser)) {
            return false;
        }
        TopHitsParser other = (TopHitsParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.returnSingleValue != other.returnSingleValue) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TopHitsParser;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + (this.returnSingleValue ? 79 : 97);
        String $name = this.getName();
        result2 = result2 * 59 + ($name == null ? 43 : $name.hashCode());
        return result2;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }
}

