/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprFloatValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.datetime.StrftimeFormatterUtil;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class StrftimeFunction
extends ImplementorUDF {
    private static final long MAX_UNIX_TIMESTAMP = 32536771199L;
    private static final int NANOS_PER_SECOND = 1000000000;

    public StrftimeFunction() {
        super(new StrftimeImplementor(), NullPolicy.STRICT);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.VARCHAR;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrap((CompositeOperandTypeChecker)((Object)OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.CHARACTER).or(OperandTypes.family(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.CHARACTER))));
    }

    public static String strftime(ExprValue unixTime, ExprValue formatString) {
        if (unixTime.isNull() || formatString.isNull()) {
            return null;
        }
        Double unixSecondsDouble = StrftimeFunction.extractUnixSecondsWithFraction(unixTime);
        if (unixSecondsDouble == null || !StrftimeFunction.isValidTimestamp(unixSecondsDouble.longValue())) {
            return null;
        }
        ZonedDateTime dateTime = StrftimeFunction.convertToZonedDateTimeWithFraction(unixSecondsDouble);
        return StrftimeFunction.formatDateTime(dateTime, formatString.stringValue());
    }

    private static Double extractUnixSecondsWithFraction(ExprValue unixTime) {
        if (unixTime instanceof ExprTimestampValue) {
            ExprTimestampValue timestamp = (ExprTimestampValue)unixTime;
            Instant instant = timestamp.timestampValue();
            return (double)instant.getEpochSecond() + (double)instant.getNano() / 1.0E9;
        }
        if (unixTime instanceof ExprDateValue) {
            ExprDateValue date = (ExprDateValue)unixTime;
            Instant instant = date.timestampValue();
            return (double)instant.getEpochSecond() + (double)instant.getNano() / 1.0E9;
        }
        Double numericValue = StrftimeFunction.extractNumericValue(unixTime);
        if (numericValue == null) {
            return null;
        }
        double absValue = Math.abs(numericValue);
        if (absValue >= 1.0E11) {
            return numericValue / 1000.0;
        }
        return numericValue;
    }

    private static Double extractNumericValue(ExprValue value) {
        if (value instanceof ExprDoubleValue) {
            return value.doubleValue();
        }
        if (value instanceof ExprLongValue) {
            return (double)value.longValue();
        }
        if (value instanceof ExprIntegerValue) {
            return (double)value.integerValue();
        }
        if (value instanceof ExprFloatValue) {
            return value.floatValue().floatValue();
        }
        return null;
    }

    private static boolean isValidTimestamp(long unixSeconds) {
        return unixSeconds >= -32536771199L && unixSeconds <= 32536771199L;
    }

    private static ZonedDateTime convertToZonedDateTimeWithFraction(double unixSeconds) {
        long seconds = (long)unixSeconds;
        int nanos = (int)((unixSeconds - (double)seconds) * 1.0E9);
        Instant instant = Instant.ofEpochSecond(seconds, nanos);
        return ZonedDateTime.ofInstant(instant, ZoneId.of("UTC"));
    }

    private static String formatDateTime(ZonedDateTime dateTime, String format) {
        ExprValue result2 = StrftimeFormatterUtil.formatZonedDateTime(dateTime, format);
        return result2.stringValue();
    }

    public static class StrftimeImplementor
    implements NotNullImplementor {
        @Override
        public Expression implement(RexToLixTranslator rexToLixTranslator, RexCall rexCall, List<Expression> list) {
            List<Expression> operands = UserDefinedFunctionUtils.convertToExprValues(list, rexCall);
            return Expressions.call(StrftimeFunction.class, "strftime", operands);
        }
    }
}

