/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class ExtractFunction
extends ImplementorUDF {
    public ExtractFunction() {
        super(new ExtractImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.BIGINT_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.STRING_DATETIME;
    }

    public static class ExtractImplementor
    implements NotNullImplementor {
        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression unit = translatedOperands.get(0);
            Expression datetime = translatedOperands.get(1);
            ExprType datetimeType = OpenSearchTypeFactory.convertRelDataTypeToExprType(call.getOperands().get(1).getType());
            MethodCallExpression functionProperties = Expressions.call(UserDefinedFunctionUtils.class, "restoreFunctionProperties", new Expression[]{translator.getRoot()});
            MethodCallExpression exprDatetimeValue = Expressions.call(ExprValueUtils.class, "fromObjectValue", new Expression[]{datetime, Expressions.constant(datetimeType)});
            NewExpression part = Expressions.new_(ExprStringValue.class, new Expression[]{unit});
            if (ExprCoreType.TIME.equals(datetimeType)) {
                return Expressions.call(ExtractImplementor.class, "extractForTime", new Expression[]{functionProperties, part, exprDatetimeValue});
            }
            return Expressions.call(ExtractImplementor.class, "extract", new Expression[]{part, exprDatetimeValue});
        }

        public static long extract(ExprStringValue part, ExprValue datetime) {
            return DateTimeFunctions.formatExtractFunction(part, datetime).longValue();
        }

        public static long extractForTime(FunctionProperties functionProperties, ExprStringValue part, ExprValue datetime) {
            return DateTimeFunctions.exprExtractForTime(functionProperties, part, datetime).longValue();
        }
    }
}

