/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public final class RexExtractMultiFunction
extends ImplementorUDF {
    public RexExtractMultiFunction() {
        super(new RexExtractMultiImplementor(), NullPolicy.ARG0);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return call -> {
            RelDataType elementType = call.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, 2000);
            return call.getTypeFactory().createArrayType(call.getTypeFactory().createTypeWithNullability(elementType, true), -1L);
        };
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.STRING_STRING_INTEGER_INTEGER;
    }

    public static List<String> extractMultipleGroups(String text, String pattern, int groupIndex, int maxMatch) {
        try {
            Pattern compiledPattern = Pattern.compile(pattern);
            Matcher matcher = compiledPattern.matcher(text);
            ArrayList<String> matches = new ArrayList<String>();
            int matchCount = 0;
            while (matcher.find() && (maxMatch == 0 || matchCount < maxMatch)) {
                String match;
                if (groupIndex <= 0 || groupIndex > matcher.groupCount() || (match = matcher.group(groupIndex)) == null) continue;
                matches.add(match);
                ++matchCount;
            }
            return matches.isEmpty() ? null : matches;
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Error in 'rex' command: Encountered the following error while compiling the regex '" + pattern + "': " + e.getMessage());
        }
    }

    private static class RexExtractMultiImplementor
    implements NotNullImplementor {
        private RexExtractMultiImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression field = translatedOperands.get(0);
            Expression pattern = translatedOperands.get(1);
            Expression groupIndex = translatedOperands.get(2);
            Expression maxMatch = translatedOperands.get(3);
            return Expressions.call(RexExtractMultiFunction.class, "extractMultipleGroups", new Expression[]{field, pattern, groupIndex, maxMatch});
        }
    }
}

