/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.transport.memorycontainer.memory.MemoryResult;

public class MLAddMemoriesResponse
extends ActionResponse
implements ToXContentObject {
    private List<MemoryResult> results;
    private String sessionId;
    private String workingMemoryId;

    public MLAddMemoriesResponse(List<MemoryResult> results, String sessionId, String workingMemoryId) {
        this.results = results != null ? results : new ArrayList();
        this.sessionId = sessionId;
        this.workingMemoryId = workingMemoryId;
    }

    public MLAddMemoriesResponse(StreamInput in) throws IOException {
        super(in);
        this.workingMemoryId = in.readOptionalString();
        int size = in.readVInt();
        this.results = new ArrayList<MemoryResult>(size);
        for (int i = 0; i < size; ++i) {
            this.results.add(new MemoryResult(in));
        }
        this.sessionId = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.workingMemoryId);
        out.writeVInt(this.results.size());
        for (MemoryResult result2 : this.results) {
            result2.writeTo(out);
        }
        out.writeOptionalString(this.sessionId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.sessionId != null) {
            builder.field("session_id", this.sessionId);
        }
        if (this.workingMemoryId != null) {
            builder.field("working_memory_id", this.workingMemoryId);
        }
        if (this.results != null && this.results.size() > 0) {
            builder.startArray("long_term_memories");
            for (MemoryResult result2 : this.results) {
                result2.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public static MLAddMemoriesResponseBuilder builder() {
        return new MLAddMemoriesResponseBuilder();
    }

    @Generated
    public List<MemoryResult> getResults() {
        return this.results;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public String getWorkingMemoryId() {
        return this.workingMemoryId;
    }

    @Generated
    public String toString() {
        return "MLAddMemoriesResponse(results=" + String.valueOf(this.getResults()) + ", sessionId=" + this.getSessionId() + ", workingMemoryId=" + this.getWorkingMemoryId() + ")";
    }

    @Generated
    public static class MLAddMemoriesResponseBuilder {
        @Generated
        private List<MemoryResult> results;
        @Generated
        private String sessionId;
        @Generated
        private String workingMemoryId;

        @Generated
        MLAddMemoriesResponseBuilder() {
        }

        @Generated
        public MLAddMemoriesResponseBuilder results(List<MemoryResult> results) {
            this.results = results;
            return this;
        }

        @Generated
        public MLAddMemoriesResponseBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public MLAddMemoriesResponseBuilder workingMemoryId(String workingMemoryId) {
            this.workingMemoryId = workingMemoryId;
            return this;
        }

        @Generated
        public MLAddMemoriesResponse build() {
            return new MLAddMemoriesResponse(this.results, this.sessionId, this.workingMemoryId);
        }

        @Generated
        public String toString() {
            return "MLAddMemoriesResponse.MLAddMemoriesResponseBuilder(results=" + String.valueOf(this.results) + ", sessionId=" + this.sessionId + ", workingMemoryId=" + this.workingMemoryId + ")";
        }
    }
}

