/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.units;

import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Objects;

public class Unit
implements Serializable {
    static final long serialVersionUID = -6704954923429734628L;
    public static final int ANGLE_UNIT = 0;
    public static final int LENGTH_UNIT = 1;
    public static final int AREA_UNIT = 2;
    public static final int VOLUME_UNIT = 3;
    public String name;
    public String plural;
    public String abbreviation;
    public double value;
    public static final NumberFormat format = NumberFormat.getNumberInstance();

    public Unit(String name, String plural, String abbreviation, double value) {
        this.name = name;
        this.plural = plural;
        this.abbreviation = abbreviation;
        this.value = value;
    }

    public double toBase(double n) {
        return n * this.value;
    }

    public double fromBase(double n) {
        return n / this.value;
    }

    public double parse(String s2) throws NumberFormatException {
        try {
            return format.parse(s2).doubleValue();
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getMessage());
        }
    }

    public String format(double n) {
        return format.format(n) + " " + this.abbreviation;
    }

    public String format(double n, boolean abbrev) {
        if (abbrev) {
            return format.format(n) + " " + this.abbreviation;
        }
        return format.format(n);
    }

    public String format(double x, double y, boolean abbrev) {
        if (abbrev) {
            return format.format(x) + "/" + format.format(y) + " " + this.abbreviation;
        }
        return format.format(x) + "/" + format.format(y);
    }

    public String format(double x, double y) {
        return this.format(x, y, true);
    }

    public String toString() {
        return this.plural;
    }

    public boolean equals(Object o) {
        if (o instanceof Unit) {
            return ((Unit)o).name.equals(this.name) && ((Unit)o).value == this.value;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.name, this.value);
    }

    static {
        format.setMaximumFractionDigits(2);
        format.setGroupingUsed(false);
    }
}

