/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.util.ProjectionMath;

public class McBrydeThomasFlatPolarSine2Projection
extends Projection {
    private static final int MAX_ITER = 10;
    private static final double LOOP_TOL = 1.0E-7;
    private static final double C1 = 0.45503;
    private static final double C2 = 1.36509;
    private static final double C3 = 1.41546;
    private static final double C_x = 0.22248;
    private static final double C_y = 1.44492;
    private static final double C1_2 = 0.3333333333333333;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        double t2;
        double k = 1.41546 * Math.sin(lpphi);
        for (int i = 10; i > 0; --i) {
            t2 = lpphi / 1.36509;
            double V = (0.45503 * Math.sin(t2) + Math.sin(lpphi) - k) / (0.3333333333333333 * Math.cos(t2) + Math.cos(lpphi));
            out.y -= V;
            if (Math.abs(V) < 1.0E-7) break;
        }
        t2 = lpphi / 1.36509;
        out.x = 0.22248 * lplam * (1.0 + 3.0 * Math.cos(lpphi) / Math.cos(t2));
        out.y = 1.44492 * Math.sin(t2);
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        double t2 = ProjectionMath.asin(xyy / 1.44492);
        out.y = 1.36509 * t2;
        out.x = xyx / (0.22248 * (1.0 + 3.0 * Math.cos(out.y) / Math.cos(t2)));
        out.y = ProjectionMath.asin((0.45503 * Math.sin(t2) + Math.sin(out.y)) / 1.41546);
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "McBryde-Thomas Flat-Pole Sine (No. 2)";
    }
}

