/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InputDecryptor;
import org.bouncycastle.crypto.OperatorUsingSecureRandom;
import org.bouncycastle.crypto.OutputDecryptor;
import org.bouncycastle.crypto.OutputEncryptor;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricOperatorFactory;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.io.CipherInputStream;
import org.bouncycastle.crypto.internal.io.CipherOutputStreamImpl;

abstract class GuardedSymmetricStreamOperatorFactory<T extends Parameters>
implements SymmetricOperatorFactory<T> {
    GuardedSymmetricStreamOperatorFactory() {
        if (!FipsStatus.isReady()) {
            throw new FipsUnapprovedOperationError("Module has not entered the ready state.");
        }
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved mode");
        }
    }

    @Override
    public final OutputEncryptor<T> createOutputEncryptor(SymmetricKey symmetricKey, T t2) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved mode", t2.getAlgorithm());
        }
        return new OutEncryptor(this, symmetricKey, t2, null);
    }

    @Override
    public OutputDecryptor<T> createOutputDecryptor(SymmetricKey symmetricKey, T t2) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved mode", t2.getAlgorithm());
        }
        final StreamCipher streamCipher = this.createCipher(false, symmetricKey, t2, null);
        return new OutputDecryptor<T>((Parameters)t2){
            final /* synthetic */ Parameters val$parameters;
            {
                this.val$parameters = parameters2;
            }

            @Override
            public CipherOutputStream getDecryptingStream(OutputStream outputStream2) {
                return CipherOutputStreamImpl.getInstance(outputStream2, streamCipher);
            }

            @Override
            public T getParameters() {
                return this.val$parameters;
            }

            @Override
            public int getMaxOutputSize(int n) {
                return n;
            }

            @Override
            public int getUpdateOutputSize(int n) {
                return n;
            }
        };
    }

    @Override
    public final InputDecryptor<T> createInputDecryptor(SymmetricKey symmetricKey, T t2) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved mode", t2.getAlgorithm());
        }
        StreamCipher streamCipher = this.createCipher(false, symmetricKey, t2, null);
        return new InputDecryptor<T>((Parameters)t2, streamCipher){
            final /* synthetic */ Parameters val$parameters;
            final /* synthetic */ StreamCipher val$cipher;
            {
                this.val$parameters = parameters2;
                this.val$cipher = streamCipher;
            }

            @Override
            public T getParameters() {
                return this.val$parameters;
            }

            @Override
            public InputStream getDecryptingStream(InputStream inputStream2) {
                return new CipherInputStream(inputStream2, this.val$cipher);
            }
        };
    }

    protected abstract StreamCipher createCipher(boolean var1, SymmetricKey var2, T var3, SecureRandom var4);

    private static class OutEncryptor
    implements OutputEncryptor<T>,
    OperatorUsingSecureRandom<OutputEncryptor<T>> {
        private final T parameters;
        private final SymmetricKey key;
        private final StreamCipher cipher;
        final /* synthetic */ GuardedSymmetricStreamOperatorFactory this$0;

        public OutEncryptor(SymmetricKey symmetricKey, T t2, SecureRandom secureRandom) {
            this.this$0 = var1_1;
            this.key = symmetricKey;
            this.parameters = t2;
            this.cipher = var1_1.createCipher(true, symmetricKey, t2, secureRandom);
        }

        @Override
        public CipherOutputStream getEncryptingStream(OutputStream outputStream2) {
            return CipherOutputStreamImpl.getInstance(outputStream2, this.cipher);
        }

        @Override
        public OutputEncryptor<T> withSecureRandom(SecureRandom secureRandom) {
            return new OutEncryptor(this.this$0, this.key, this.parameters, secureRandom);
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public int getMaxOutputSize(int n) {
            return n;
        }

        @Override
        public int getUpdateOutputSize(int n) {
            return n;
        }
    }
}

