/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidWrappingException;
import org.bouncycastle.crypto.Key;
import org.bouncycastle.crypto.KeyUnwrapper;
import org.bouncycastle.crypto.KeyWrapOperatorFactory;
import org.bouncycastle.crypto.KeyWrapper;
import org.bouncycastle.crypto.KeyWrapperUsingSecureRandom;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.internal.Wrapper;

abstract class GuardedKeyWrapOperatorFactory<T extends Parameters, K extends Key>
implements KeyWrapOperatorFactory<T, K> {
    GuardedKeyWrapOperatorFactory() {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
        }
    }

    @Override
    public KeyWrapper<T> createKeyWrapper(K k, T t2) {
        return new GuardedWrapper(this, k, t2, null);
    }

    @Override
    public KeyUnwrapper<T> createKeyUnwrapper(K k, T t2) {
        return new GuardedUnwrapper(this, t2.getAlgorithm(), t2, this.createWrapper(false, k, t2, null));
    }

    protected abstract Wrapper createWrapper(boolean var1, K var2, T var3, SecureRandom var4);

    private static class GuardedUnwrapper
    implements KeyUnwrapper<T> {
        private final Algorithm algorithm;
        private final T parameters;
        private final Wrapper wrapper;
        final /* synthetic */ GuardedKeyWrapOperatorFactory this$0;

        GuardedUnwrapper(Algorithm algorithm, T t2, Wrapper wrapper) {
            this.this$0 = var1_1;
            this.algorithm = algorithm;
            this.parameters = t2;
            this.wrapper = wrapper;
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public byte[] unwrap(byte[] byArray, int n, int n2) throws InvalidWrappingException {
            Utils.approveModeCheck(this.algorithm);
            try {
                return this.wrapper.unwrap(byArray, n, n2);
            }
            catch (Exception exception) {
                throw new InvalidWrappingException("Unable to unwrap key: " + exception.getMessage(), exception);
            }
        }
    }

    private static class GuardedWrapper
    implements KeyWrapperUsingSecureRandom<T> {
        private final Algorithm algorithm;
        private final K key;
        private final T parameters;
        private final SecureRandom random;
        private Wrapper wrapper;
        final /* synthetic */ GuardedKeyWrapOperatorFactory this$0;

        GuardedWrapper(K k, T t2, SecureRandom secureRandom) {
            this.this$0 = var1_1;
            this.algorithm = t2.getAlgorithm();
            this.key = k;
            this.parameters = t2;
            this.random = secureRandom;
        }

        void setUp() {
            if (this.wrapper == null) {
                this.wrapper = this.this$0.createWrapper(true, this.key, this.parameters, this.random);
            }
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public byte[] wrap(byte[] byArray, int n, int n2) {
            Utils.approveModeCheck(this.algorithm);
            this.setUp();
            return this.wrapper.wrap(byArray, n, n2);
        }

        @Override
        public KeyWrapperUsingSecureRandom<T> withSecureRandom(SecureRandom secureRandom) {
            return new GuardedWrapper(this.this$0, this.key, this.parameters, secureRandom);
        }
    }
}

