/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.general.ChaCha20Poly1305;
import org.bouncycastle.crypto.general.ChaCha7539Engine;
import org.bouncycastle.crypto.general.CipherKeyGenerator;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralAuthParameters;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedAEADOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import org.bouncycastle.crypto.general.GuardedSymmetricStreamOperatorFactory;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.SelfTestExecutor;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.general.VariantKatTest;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.modes.AEADCipher;
import org.bouncycastle.crypto.internal.params.AEADParameters;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithCounter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public final class ChaCha20 {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("ChaCha20");
    public static final GeneralAlgorithm STREAMwithPoly1305 = new GeneralAlgorithm("ChaCha20-Poly1305");
    private static final EngineProvider ENGINE_PROVIDER;
    public static final Parameters STREAM;
    public static final AuthParameters WithPoly1305;

    private ChaCha20() {
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey symmetricKey, Algorithm algorithm) {
        ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
        int n = validatedSymmetricKey.getKeySizeInBits();
        if (ChaCha20.invalidKeySize(n)) {
            throw new IllegalKeyException("ChaCha20 key must be 256 bits");
        }
        Utils.checkKeyAlgorithm(validatedSymmetricKey, ALGORITHM, algorithm);
        return validatedSymmetricKey;
    }

    private static boolean invalidKeySize(int n) {
        return n != 256;
    }

    static {
        EngineProvider engineProvider = new EngineProvider();
        engineProvider.createEngine();
        ENGINE_PROVIDER = engineProvider;
        STREAM = new Parameters(ALGORITHM);
        WithPoly1305 = new AuthParameters(STREAMwithPoly1305);
    }

    public static final class AEADOperatorFactory
    extends GuardedAEADOperatorFactory<AuthParameters> {
        @Override
        protected AEADCipher createAEADCipher(boolean bl, SymmetricKey symmetricKey, AuthParameters authParameters) {
            ChaCha20Poly1305 chaCha20Poly1305 = new ChaCha20Poly1305();
            KeyParameterImpl keyParameterImpl = new KeyParameterImpl(ChaCha20.validateKey(symmetricKey, authParameters.getAlgorithm()).getKeyBytes());
            if (authParameters.getIV() != null) {
                chaCha20Poly1305.init(bl, new AEADParameters(keyParameterImpl, authParameters.getMACSizeInBits(), authParameters.getIV()));
            } else {
                chaCha20Poly1305.init(bl, keyParameterImpl);
            }
            return chaCha20Poly1305;
        }
    }

    public static final class AuthParameters
    extends GeneralAuthParameters<AuthParameters> {
        private AuthParameters(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n) {
            super(generalAlgorithm, 12, byArray, n);
            if (byArray != null && byArray.length != 12) {
                throw new IllegalArgumentException("IV must be 12 bytes long");
            }
        }

        AuthParameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null, 128);
        }

        @Override
        public AuthParameters withIV(SecureRandom secureRandom) {
            byte[] byArray = new byte[12];
            secureRandom.nextBytes(byArray);
            return this.create((GeneralAlgorithm)this.getAlgorithm(), byArray);
        }

        @Override
        protected AuthParameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            return new AuthParameters(generalAlgorithm, byArray, this.macLenInBits);
        }

        @Override
        AuthParameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n) {
            return new AuthParameters(generalAlgorithm, byArray, n);
        }
    }

    private static final class EngineProvider
    implements org.bouncycastle.crypto.internal.EngineProvider<StreamCipher> {
        static final byte[] input = Hex.decode("00112233445566778899aabbccddeeff");
        static final byte[] output = Hex.decode("39ec094e9d907f1d0524a9cc7401a4b6");
        static final byte[] iv = Hex.decode("000000000000000000000000");
        static final byte[] key = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");

        private EngineProvider() {
        }

        @Override
        public StreamCipher createEngine() {
            return SelfTestExecutor.validate((Algorithm)ALGORITHM, new ChaCha7539Engine(), new VariantKatTest<ChaCha7539Engine>(){

                @Override
                public void evaluate(ChaCha7539Engine chaCha7539Engine) {
                    byte[] byArray = new byte[input.length];
                    chaCha7539Engine.init(true, new org.bouncycastle.crypto.internal.params.ParametersWithIV(new KeyParameterImpl(key), iv));
                    chaCha7539Engine.processBytes(input, 0, input.length, byArray, 0);
                    if (!Arrays.areEqual(output, byArray)) {
                        this.fail("Failed self test on encryption");
                    }
                    chaCha7539Engine.init(false, new org.bouncycastle.crypto.internal.params.ParametersWithIV(new KeyParameterImpl(key), iv));
                    chaCha7539Engine.processBytes(output, 0, output.length, byArray, 0);
                    if (!Arrays.areEqual(input, byArray)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private static final int keySizeInBits = 256;
        private final GeneralAlgorithm algorithm;
        private final SecureRandom random;

        public KeyGenerator(SecureRandom secureRandom) {
            this(ALGORITHM, secureRandom);
        }

        public KeyGenerator(GeneralParameters generalParameters, SecureRandom secureRandom) {
            this((GeneralAlgorithm)generalParameters.getAlgorithm(), secureRandom);
        }

        private KeyGenerator(GeneralAlgorithm generalAlgorithm, SecureRandom secureRandom) {
            this.algorithm = generalAlgorithm;
            this.random = secureRandom;
        }

        @Override
        public SymmetricKey doGenerateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, 256));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    public static final class OperatorFactory
    extends GuardedSymmetricStreamOperatorFactory<Parameters> {
        @Override
        protected StreamCipher createCipher(boolean bl, SymmetricKey symmetricKey, Parameters parameters2, SecureRandom secureRandom) {
            StreamCipher streamCipher = ENGINE_PROVIDER.createEngine();
            KeyParameter keyParameter = Utils.getKeyParameter(ChaCha20.validateKey(symmetricKey, parameters2.getAlgorithm()));
            if (parameters2.iv == null || parameters2.iv.length != 12) {
                throw new IllegalArgumentException("IV must be 12 bytes long");
            }
            if (parameters2.counter != 0) {
                streamCipher.init(bl, new ParametersWithCounter(new org.bouncycastle.crypto.internal.params.ParametersWithIV(keyParameter, parameters2.iv), parameters2.counter));
            } else {
                streamCipher.init(bl, new org.bouncycastle.crypto.internal.params.ParametersWithIV(keyParameter, parameters2.iv));
            }
            return streamCipher;
        }
    }

    public static final class Parameters
    extends GeneralParameters<GeneralAlgorithm>
    implements ParametersWithIV {
        private final byte[] iv;
        private final int counter;

        private Parameters(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n) {
            super(generalAlgorithm);
            if (byArray != null && byArray.length != 12) {
                throw new IllegalArgumentException("IV must be 12 bytes long");
            }
            this.iv = byArray;
            this.counter = n;
        }

        Parameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null, 0);
        }

        @Override
        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }

        public int getCounter() {
            return this.counter;
        }

        public Parameters withIV(byte[] byArray) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), Arrays.clone(byArray), this.counter);
        }

        public Parameters withIV(SecureRandom secureRandom) {
            byte[] byArray = new byte[12];
            secureRandom.nextBytes(byArray);
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), byArray, this.counter);
        }

        public Parameters withCounter(int n) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), this.iv, n);
        }
    }
}

