/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSpatialTypeOperatorTable;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.util.ListSqlOperatorTable;
import shaded.com.google.common.base.Suppliers;
import shaded.com.google.common.collect.ImmutableCollection;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMultimap;
import shaded.com.google.common.collect.Multimap;

public class SqlOperatorTables {
    private static final Supplier<SqlOperatorTable> SPATIAL = Suppliers.memoize(SqlSpatialTypeOperatorTable::new);

    private SqlOperatorTables() {
    }

    public static SqlOperatorTable spatialInstance() {
        return SPATIAL.get();
    }

    public static SqlOperatorTable chain(Iterable<SqlOperatorTable> tables) {
        ArrayList<SqlOperatorTable> list = new ArrayList<SqlOperatorTable>();
        for (SqlOperatorTable table : tables) {
            SqlOperatorTables.addFlattened(list, table);
        }
        if (list.size() == 1) {
            return (SqlOperatorTable)list.get(0);
        }
        return new ChainedSqlOperatorTable(ImmutableList.copyOf(list));
    }

    private static void addFlattened(List<SqlOperatorTable> list, SqlOperatorTable table) {
        if (table instanceof ChainedSqlOperatorTable) {
            ChainedSqlOperatorTable chainedTable = (ChainedSqlOperatorTable)table;
            for (SqlOperatorTable table2 : chainedTable.tableList) {
                SqlOperatorTables.addFlattened(list, table2);
            }
        } else if (!(table instanceof ImmutableListSqlOperatorTable) || !table.getOperatorList().isEmpty()) {
            list.add(table);
        }
    }

    public static SqlOperatorTable chain(SqlOperatorTable ... tables) {
        return SqlOperatorTables.chain(ImmutableList.copyOf(tables));
    }

    public static SqlOperatorTable of(Iterable<? extends SqlOperator> list) {
        return new ImmutableListSqlOperatorTable((Iterable<? extends SqlOperator>)ImmutableList.copyOf(list));
    }

    public static SqlOperatorTable of(SqlOperator ... operators) {
        return SqlOperatorTables.of(ImmutableList.copyOf(operators));
    }

    static abstract class IndexedSqlOperatorTable
    implements SqlOperatorTable {
        protected ImmutableMultimap<String, SqlOperator> operators;

        protected IndexedSqlOperatorTable(Iterable<? extends SqlOperator> list) {
            this.operators = IndexedSqlOperatorTable.buildIndex(list);
        }

        @Override
        public List<SqlOperator> getOperatorList() {
            return ((ImmutableCollection)this.operators.values()).asList();
        }

        protected void setOperators(Multimap<String, SqlOperator> operators) {
            this.operators = ImmutableMultimap.copyOf(operators);
        }

        protected static ImmutableMultimap<String, SqlOperator> buildIndex(Iterable<? extends SqlOperator> operators) {
            ImmutableMultimap.Builder map = ImmutableMultimap.builder();
            operators.forEach(op -> map.put(op.getName().toUpperCase(Locale.ROOT), op));
            return map.build();
        }

        protected void lookUpOperators(String name, boolean caseSensitive, Consumer<SqlOperator> consumer) {
            String upperName = name.toUpperCase(Locale.ROOT);
            if (caseSensitive) {
                this.operators.get((Object)upperName).forEach(operator -> {
                    if (operator.getName().equals(name)) {
                        consumer.accept((SqlOperator)operator);
                    }
                });
            } else {
                this.operators.get((Object)upperName).forEach(consumer);
            }
        }
    }

    private static class ImmutableListSqlOperatorTable
    extends ListSqlOperatorTable {
        ImmutableListSqlOperatorTable(Iterable<? extends SqlOperator> operators) {
            super(operators);
        }
    }
}

