/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeTransform;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;

public class SqlMultisetQueryConstructor
extends SqlSpecialOperator {
    final SqlTypeTransform typeTransform;

    public SqlMultisetQueryConstructor() {
        this("MULTISET", SqlKind.MULTISET_QUERY_CONSTRUCTOR, SqlTypeTransforms.TO_MULTISET_QUERY);
    }

    protected SqlMultisetQueryConstructor(String name, SqlKind kind, SqlTypeTransform typeTransform) {
        super(name, kind, 200, false, ReturnTypes.ARG0.andThen(typeTransform), null, OperandTypes.VARIADIC);
        this.typeTransform = typeTransform;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List<RelDataType> argTypes = SqlTypeUtil.deriveType(callBinding, callBinding.operands());
        RelDataType componentType = callBinding.getTypeFactory().leastRestrictive(argTypes);
        if (null == componentType) {
            if (throwOnFailure) {
                throw callBinding.newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            return false;
        }
        return true;
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope2, SqlCall call) {
        SqlSelect subSelect = (SqlSelect)call.operand(0);
        subSelect.validateExpr(validator, scope2);
        SqlValidatorNamespace ns = Objects.requireNonNull(validator.getNamespace(subSelect), () -> "namespace is missing for " + subSelect);
        RelDataType rowType = Objects.requireNonNull(ns.getRowType(), "rowType");
        SqlCallBinding opBinding = new SqlCallBinding(validator, scope2, call);
        return this.typeTransform.transformType(opBinding, rowType);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        writer.keyword(this.getName());
        SqlWriter.Frame frame = writer.startList("(", ")");
        assert (call.operandCount() == 1);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return false;
    }
}

