/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.FunctionContext;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.util.ReflectUtil;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableList;

public abstract class ReflectiveFunctionBase
implements Function {
    public final Method method;
    public final List<FunctionParameter> parameters;

    protected ReflectiveFunctionBase(Method method) {
        this.method = method;
        this.parameters = ReflectiveFunctionBase.builder().addMethodParameters(method).build();
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return this.parameters;
    }

    static boolean classHasPublicZeroArgsConstructor(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterCount() != 0 || !ReflectUtil.isPublic(constructor)) continue;
            return true;
        }
        return false;
    }

    static boolean classHasPublicFunctionContextConstructor(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterCount() != 1 || constructor.getParameterTypes()[0] != FunctionContext.class || !ReflectUtil.isPublic(constructor)) continue;
            return true;
        }
        return false;
    }

    static @Nullable Method findMethod(Class<?> clazz, String name) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name) || method.isBridge()) continue;
            return method;
        }
        return null;
    }

    public static ParameterListBuilder builder() {
        return new ParameterListBuilder();
    }

    public static class ParameterListBuilder {
        final List<FunctionParameter> builder = new ArrayList<FunctionParameter>();

        public ImmutableList<FunctionParameter> build() {
            return ImmutableList.copyOf(this.builder);
        }

        public ParameterListBuilder add(Class<?> type2, String name) {
            return this.add(type2, name, false);
        }

        public ParameterListBuilder add(final Class<?> type2, final String name, final boolean optional) {
            final int ordinal = this.builder.size();
            this.builder.add(new FunctionParameter(){

                public String toString() {
                    return ordinal + ": " + name + " " + type2.getSimpleName() + (optional ? "?" : "");
                }

                @Override
                public int getOrdinal() {
                    return ordinal;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public RelDataType getType(RelDataTypeFactory typeFactory) {
                    return typeFactory.createJavaType(type2);
                }

                @Override
                public boolean isOptional() {
                    return optional;
                }
            });
            return this;
        }

        public ParameterListBuilder addMethodParameters(Method method) {
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                this.add(types[i], ReflectUtil.getParameterName(method, i), ReflectUtil.isParameterOptional(method, i));
            }
            return this;
        }
    }
}

