/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.runtime.ImmutablePairList;
import org.apache.calcite.runtime.PairLists;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.collect.Lists;

public interface PairList<T, U>
extends List<Map.Entry<T, U>> {
    public static <T, U> PairList<T, U> of() {
        return new PairLists.MutablePairList(new ArrayList<Object>());
    }

    public static <T, U> PairList<T, U> of(T t2, U u) {
        ArrayList<@Nullable Object> list = new ArrayList<Object>();
        list.add(t2);
        list.add(u);
        return new PairLists.MutablePairList(list);
    }

    public static <T, U> PairList<T, U> copyOf(T t2, U u, Object ... rest) {
        Preconditions.checkArgument(rest.length % 2 == 0, "even number");
        List<@Nullable Object> list = Lists.asList(t2, u, rest);
        return new PairLists.MutablePairList(new ArrayList<Object>(list));
    }

    public static <T, U> PairList<T, U> withCapacity(int initialCapacity) {
        return PairList.backedBy(new ArrayList<Object>(initialCapacity));
    }

    public static <T, U> PairList<T, U> backedBy(List<@Nullable Object> list) {
        return new PairLists.MutablePairList(list);
    }

    public static <T, U> PairList<T, U> of(Map<T, U> map) {
        ArrayList<@Nullable Object> list = new ArrayList<Object>(map.size() * 2);
        map.forEach((? super K t2, ? super V u) -> {
            list.add(t2);
            list.add(u);
        });
        return new PairLists.MutablePairList(list);
    }

    public static <T, U> Builder<T, U> builder() {
        return new Builder();
    }

    default public void add(T t2, U u) {
        throw new UnsupportedOperationException("add");
    }

    default public void add(int index, T t2, U u) {
        throw new UnsupportedOperationException("add");
    }

    default public boolean addAll(PairList<T, U> list2) {
        throw new UnsupportedOperationException("addAll");
    }

    default public boolean addAll(int index, PairList<T, U> list2) {
        throw new UnsupportedOperationException("addAll");
    }

    default public Map.Entry<T, U> set(int index, T t2, U u) {
        throw new UnsupportedOperationException("set");
    }

    @Override
    default public Map.Entry<T, U> remove(int index) {
        throw new UnsupportedOperationException("remove");
    }

    public T left(int var1);

    public U right(int var1);

    public List<T> leftList();

    public List<U> rightList();

    public void forEach(BiConsumer<T, U> var1);

    public void forEachIndexed(IndexedBiConsumer<T, U> var1);

    default public ImmutableMap<T, U> toImmutableMap() {
        ImmutableMap.Builder b = ImmutableMap.builder();
        this.forEach((T t2, U u) -> b.put(t2, u));
        return b.build();
    }

    public ImmutablePairList<T, U> immutable();

    public <R> List<R> transform(BiFunction<T, U, R> var1);

    public <R> ImmutableList<R> transform2(BiFunction<T, U, R> var1);

    public PairList<T, U> subList(int var1, int var2);

    public boolean anyMatch(BiPredicate<T, U> var1);

    public boolean allMatch(BiPredicate<T, U> var1);

    public boolean noMatch(BiPredicate<T, U> var1);

    default public void reverse() {
        throw new UnsupportedOperationException("reverse");
    }

    @Override
    public ImmutablePairList<T, U> reversed();

    @Deprecated
    public static class Helper {
        private Helper() {
        }

        public static <T, U> PairList<T, U> copyOf(T t2, U u, Object ... rest) {
            return PairList.copyOf(t2, u, rest);
        }
    }

    public static class Builder<T, U> {
        final List<@Nullable Object> list = new ArrayList<Object>();

        public Builder<T, U> add(T t2, U u) {
            this.list.add(t2);
            this.list.add(u);
            return this;
        }

        public PairList<T, U> build() {
            return new PairLists.MutablePairList(this.list);
        }

        public ImmutablePairList<T, U> buildImmutable() {
            return PairLists.immutableBackedBy(Nullness.castNonNullList(this.list));
        }
    }

    public static interface IndexedBiConsumer<T, U> {
        public void accept(int var1, T var2, U var3);
    }
}

