/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.rules.SubQueryRemoveRule;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Generated;
import shaded.com.google.common.base.MoreObjects;

@ParametersAreNonnullByDefault
@Generated(from="SubQueryRemoveRule", generator="Immutables")
final class ImmutableSubQueryRemoveRule {
    private ImmutableSubQueryRemoveRule() {
    }

    @CheckReturnValue
    @Generated(from="SubQueryRemoveRule.Config", generator="Immutables")
    @Immutable
    static final class Config
    implements SubQueryRemoveRule.Config {
        private final RelBuilderFactory relBuilderFactory;
        @Nullable
        private final @org.checkerframework.checker.nullness.qual.Nullable String description;
        private final RelRule.OperandTransform operandSupplier;
        private final RelRule.MatchHandler<SubQueryRemoveRule> matchHandler;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private Config(Builder builder) {
            this.description = builder.description;
            this.matchHandler = builder.matchHandler;
            if (builder.relBuilderFactory != null) {
                this.initShim.withRelBuilderFactory(builder.relBuilderFactory);
            }
            if (builder.operandSupplier != null) {
                this.initShim.withOperandSupplier(builder.operandSupplier);
            }
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.operandSupplier = this.initShim.operandSupplier();
            this.initShim = null;
        }

        private Config(RelBuilderFactory relBuilderFactory, @Nullable @org.checkerframework.checker.nullness.qual.Nullable String description2, RelRule.OperandTransform operandSupplier, RelRule.MatchHandler<SubQueryRemoveRule> matchHandler) {
            this.relBuilderFactory = relBuilderFactory;
            this.description = description2;
            this.operandSupplier = operandSupplier;
            this.matchHandler = matchHandler;
            this.initShim = null;
        }

        private RelBuilderFactory relBuilderFactoryInitialize() {
            return SubQueryRemoveRule.Config.super.relBuilderFactory();
        }

        private RelRule.OperandTransform operandSupplierInitialize() {
            return SubQueryRemoveRule.Config.super.operandSupplier();
        }

        @Override
        public RelBuilderFactory relBuilderFactory() {
            InitShim shim = this.initShim;
            return shim != null ? shim.relBuilderFactory() : this.relBuilderFactory;
        }

        @Override
        @Nullable
        public @org.checkerframework.checker.nullness.qual.Nullable String description() {
            return this.description;
        }

        @Override
        public RelRule.OperandTransform operandSupplier() {
            InitShim shim = this.initShim;
            return shim != null ? shim.operandSupplier() : this.operandSupplier;
        }

        @Override
        public RelRule.MatchHandler<SubQueryRemoveRule> matchHandler() {
            return this.matchHandler;
        }

        @Override
        public final Config withRelBuilderFactory(RelBuilderFactory value) {
            if (this.relBuilderFactory == value) {
                return this;
            }
            RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
            return new Config(newValue, this.description, this.operandSupplier, this.matchHandler);
        }

        @Override
        public final Config withDescription(@Nullable @org.checkerframework.checker.nullness.qual.Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return new Config(this.relBuilderFactory, value, this.operandSupplier, this.matchHandler);
        }

        @Override
        public final Config withOperandSupplier(RelRule.OperandTransform value) {
            if (this.operandSupplier == value) {
                return this;
            }
            RelRule.OperandTransform newValue = Objects.requireNonNull(value, "operandSupplier");
            return new Config(this.relBuilderFactory, this.description, newValue, this.matchHandler);
        }

        @Override
        public final Config withMatchHandler(RelRule.MatchHandler<SubQueryRemoveRule> value) {
            if (this.matchHandler == value) {
                return this;
            }
            RelRule.MatchHandler<SubQueryRemoveRule> newValue = Objects.requireNonNull(value, "matchHandler");
            return new Config(this.relBuilderFactory, this.description, this.operandSupplier, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Config && this.equalTo((Config)another);
        }

        private boolean equalTo(Config another) {
            return this.relBuilderFactory.equals(another.relBuilderFactory) && Objects.equals(this.description, another.description) && this.operandSupplier.equals(another.operandSupplier) && this.matchHandler.equals(another.matchHandler);
        }

        public int hashCode() {
            int h2 = 5381;
            h2 += (h2 << 5) + this.relBuilderFactory.hashCode();
            h2 += (h2 << 5) + Objects.hashCode(this.description);
            h2 += (h2 << 5) + this.operandSupplier.hashCode();
            h2 += (h2 << 5) + this.matchHandler.hashCode();
            return h2;
        }

        public String toString() {
            return MoreObjects.toStringHelper("Config").omitNullValues().add("relBuilderFactory", this.relBuilderFactory).add("description", this.description).add("operandSupplier", this.operandSupplier).add("matchHandler", this.matchHandler).toString();
        }

        public static Config copyOf(SubQueryRemoveRule.Config instance) {
            if (instance instanceof Config) {
                return (Config)instance;
            }
            return Config.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SubQueryRemoveRule.Config", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_MATCH_HANDLER = 1L;
            private long initBits = 1L;
            @Nullable
            private RelBuilderFactory relBuilderFactory;
            @Nullable
            private @org.checkerframework.checker.nullness.qual.Nullable String description;
            @Nullable
            private RelRule.OperandTransform operandSupplier;
            @Nullable
            private RelRule.MatchHandler<SubQueryRemoveRule> matchHandler;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(SubQueryRemoveRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(RelRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                RelRule.Config instance;
                if (object instanceof SubQueryRemoveRule.Config) {
                    instance = (SubQueryRemoveRule.Config)object;
                    this.withMatchHandler(instance.matchHandler());
                }
                if (object instanceof RelRule.Config) {
                    instance = (RelRule.Config)object;
                    this.withRelBuilderFactory(instance.relBuilderFactory());
                    this.withOperandSupplier(instance.operandSupplier());
                    @org.checkerframework.checker.nullness.qual.Nullable String descriptionValue = instance.description();
                    if (descriptionValue != null) {
                        this.withDescription(descriptionValue);
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withDescription(@Nullable @org.checkerframework.checker.nullness.qual.Nullable String description2) {
                this.description = description2;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = Objects.requireNonNull(operandSupplier, "operandSupplier");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withMatchHandler(RelRule.MatchHandler<SubQueryRemoveRule> matchHandler) {
                this.matchHandler = Objects.requireNonNull(matchHandler, "matchHandler");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Config build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Config(this);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("matchHandler");
                }
                return "Cannot build Config, some of required attributes are not set " + attributes;
            }
        }

        @Generated(from="SubQueryRemoveRule.Config", generator="Immutables")
        private final class InitShim {
            private byte relBuilderFactoryBuildStage = 0;
            private RelBuilderFactory relBuilderFactory;
            private byte operandSupplierBuildStage = 0;
            private RelRule.OperandTransform operandSupplier;

            private InitShim() {
            }

            RelBuilderFactory relBuilderFactory() {
                if (this.relBuilderFactoryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.relBuilderFactoryBuildStage == 0) {
                    this.relBuilderFactoryBuildStage = (byte)-1;
                    this.relBuilderFactory = Objects.requireNonNull(Config.this.relBuilderFactoryInitialize(), "relBuilderFactory");
                    this.relBuilderFactoryBuildStage = 1;
                }
                return this.relBuilderFactory;
            }

            void withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = relBuilderFactory;
                this.relBuilderFactoryBuildStage = 1;
            }

            RelRule.OperandTransform operandSupplier() {
                if (this.operandSupplierBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.operandSupplierBuildStage == 0) {
                    this.operandSupplierBuildStage = (byte)-1;
                    this.operandSupplier = Objects.requireNonNull(Config.this.operandSupplierInitialize(), "operandSupplier");
                    this.operandSupplierBuildStage = 1;
                }
                return this.operandSupplier;
            }

            void withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = operandSupplier;
                this.operandSupplierBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.relBuilderFactoryBuildStage == -1) {
                    attributes.add("relBuilderFactory");
                }
                if (this.operandSupplierBuildStage == -1) {
                    attributes.add("operandSupplier");
                }
                return "Cannot build Config, attribute initializers form cycle " + attributes;
            }
        }
    }
}

