/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.Locale;
import org.apiguardian.api.API;

public enum JoinRelType {
    INNER,
    LEFT,
    RIGHT,
    FULL,
    SEMI,
    ANTI,
    ASOF,
    LEFT_ASOF;

    public final String lowerName = this.name().toLowerCase(Locale.ROOT);

    public boolean generatesNullsOnRight() {
        return this == LEFT || this == FULL || this == LEFT_ASOF;
    }

    public boolean generatesNullsOnLeft() {
        return this == RIGHT || this == FULL;
    }

    public boolean isOuterJoin() {
        return this == LEFT || this == RIGHT || this == FULL || this == LEFT_ASOF;
    }

    public JoinRelType swap() {
        switch (this) {
            case LEFT: {
                return RIGHT;
            }
            case RIGHT: {
                return LEFT;
            }
        }
        return this;
    }

    public boolean generatesNullsOn(int i) {
        switch (i) {
            case 0: {
                return this.generatesNullsOnLeft();
            }
            case 1: {
                return this.generatesNullsOnRight();
            }
        }
        throw new IllegalArgumentException("invalid: " + i);
    }

    public JoinRelType cancelNullsOnLeft() {
        switch (this) {
            case RIGHT: {
                return INNER;
            }
            case FULL: {
                return LEFT;
            }
        }
        return this;
    }

    public JoinRelType cancelNullsOnRight() {
        switch (this) {
            case LEFT: {
                return INNER;
            }
            case FULL: {
                return RIGHT;
            }
        }
        return this;
    }

    public boolean projectsRight() {
        return this != SEMI && this != ANTI;
    }

    @API(since="1.28", status=API.Status.EXPERIMENTAL)
    public boolean canPushIntoFromAbove() {
        return this == INNER || this == SEMI;
    }

    @API(since="1.28", status=API.Status.EXPERIMENTAL)
    public boolean canPushLeftFromAbove() {
        return this == INNER || this == LEFT || this == SEMI || this == ANTI;
    }

    @API(since="1.28", status=API.Status.EXPERIMENTAL)
    public boolean canPushRightFromAbove() {
        return this == INNER || this == RIGHT;
    }

    @API(since="1.28", status=API.Status.EXPERIMENTAL)
    public boolean canPushLeftFromWithin() {
        return this == INNER || this == RIGHT || this == SEMI;
    }

    @API(since="1.28", status=API.Status.EXPERIMENTAL)
    public boolean canPushRightFromWithin() {
        return this == INNER || this == LEFT || this == SEMI;
    }
}

