/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.MulticastRelOptListener;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptListener;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.RuleEventLogger;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.util.CancelFlag;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.slf4j.Logger;
import shaded.com.google.common.collect.ImmutableList;

public abstract class AbstractRelOptPlanner
implements RelOptPlanner {
    private static final Logger RULE_ATTEMPTS_LOGGER = CalciteTrace.getRuleAttemptsTracer();
    protected final Map<String, RelOptRule> mapDescToRule = new LinkedHashMap<String, RelOptRule>();
    protected final RelOptCostFactory costFactory;
    private @MonotonicNonNull MulticastRelOptListener listener;
    private @MonotonicNonNull RuleAttemptsListener ruleAttemptsListener;
    private @Nullable Pattern ruleDescExclusionFilter;
    protected final AtomicBoolean cancelFlag;
    private final Set<Class<? extends RelNode>> classes = new HashSet<Class<? extends RelNode>>();
    private final Set<Convention> conventions = new HashSet<Convention>();
    protected final Context context;
    private @Nullable RexExecutor executor;

    protected AbstractRelOptPlanner(RelOptCostFactory costFactory, @Nullable Context context) {
        this.costFactory = Objects.requireNonNull(costFactory, "costFactory");
        if (context == null) {
            context = Contexts.empty();
        }
        this.context = context;
        this.cancelFlag = context.maybeUnwrap(CancelFlag.class).map(flag -> flag.atomicBoolean).orElseGet(AtomicBoolean::new);
        this.classes.add(RelNode.class);
        this.classes.add(RelSubset.class);
        if (RULE_ATTEMPTS_LOGGER.isDebugEnabled()) {
            this.ruleAttemptsListener = new RuleAttemptsListener();
            this.addListener(this.ruleAttemptsListener);
        }
        this.addListener(new RuleEventLogger());
    }

    @Override
    public void clear() {
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public RelOptCostFactory getCostFactory() {
        return this.costFactory;
    }

    @Override
    public void setCancelFlag(CancelFlag cancelFlag) {
    }

    public void checkCancel() {
        if (this.cancelFlag.get()) {
            throw Static.RESOURCE.preparationAborted().ex();
        }
    }

    @Override
    public List<RelOptRule> getRules() {
        return ImmutableList.copyOf(this.mapDescToRule.values());
    }

    @Override
    public boolean addRule(RelOptRule rule) {
        String description2 = Objects.requireNonNull(rule.toString());
        RelOptRule existingRule = this.mapDescToRule.put(description2, rule);
        if (existingRule != null) {
            if (existingRule.equals(rule)) {
                return false;
            }
            throw new AssertionError((Object)("Rule's description should be unique; existing rule=" + existingRule + "; new rule=" + rule));
        }
        return true;
    }

    @Override
    public boolean removeRule(RelOptRule rule) {
        String description2 = rule.toString();
        RelOptRule removed = this.mapDescToRule.remove(description2);
        return removed != null;
    }

    protected @Nullable RelOptRule getRuleByDescription(String description2) {
        return this.mapDescToRule.get(description2);
    }

    @Override
    public void setRuleDescExclusionFilter(@Nullable Pattern exclusionFilter) {
        this.ruleDescExclusionFilter = exclusionFilter;
    }

    public boolean isRuleExcluded(RelOptRule rule) {
        return this.ruleDescExclusionFilter != null && this.ruleDescExclusionFilter.matcher(rule.toString()).matches();
    }

    @Override
    public RelOptPlanner chooseDelegate() {
        return this;
    }

    @Override
    public void addMaterialization(RelOptMaterialization materialization) {
    }

    @Override
    public List<RelOptMaterialization> getMaterializations() {
        return ImmutableList.of();
    }

    @Override
    public void addLattice(RelOptLattice lattice) {
    }

    @Override
    public @Nullable RelOptLattice getLattice(RelOptTable table) {
        return null;
    }

    @Override
    public void registerSchema(RelOptSchema schema) {
    }

    @Override
    @Deprecated
    public long getRelMetadataTimestamp(RelNode rel) {
        return 0L;
    }

    @Override
    public void prune(RelNode rel) {
    }

    @Override
    public void registerClass(RelNode node) {
        Convention convention;
        Class<?> clazz = node.getClass();
        if (this.classes.add(clazz)) {
            this.onNewClass(node);
        }
        if ((convention = node.getConvention()) != null && this.conventions.add(convention)) {
            convention.register(this);
        }
    }

    protected void onNewClass(RelNode node) {
        node.register(this);
    }

    @Override
    public RelTraitSet emptyTraitSet() {
        return RelTraitSet.createEmpty();
    }

    @Override
    public @Nullable RelOptCost getCost(RelNode rel, RelMetadataQuery mq) {
        return mq.getCumulativeCost(rel);
    }

    @Override
    @Deprecated
    public @Nullable RelOptCost getCost(RelNode rel) {
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        return this.getCost(rel, mq);
    }

    @Override
    public void addListener(@UnknownInitialization AbstractRelOptPlanner this, RelOptListener newListener) {
        if (this.listener == null) {
            this.listener = new MulticastRelOptListener();
        }
        this.listener.addListener(newListener);
    }

    @Override
    @Deprecated
    public void registerMetadataProviders(List<RelMetadataProvider> list) {
    }

    @Override
    public boolean addRelTraitDef(RelTraitDef relTraitDef) {
        return false;
    }

    @Override
    public void clearRelTraitDefs() {
    }

    @Override
    public List<RelTraitDef> getRelTraitDefs() {
        return ImmutableList.of();
    }

    @Override
    public void setExecutor(@Nullable RexExecutor executor) {
        this.executor = executor;
    }

    @Override
    public @Nullable RexExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public void onCopy(RelNode rel, RelNode newRel) {
    }

    protected void dumpRuleAttemptsInfo() {
        if (this.ruleAttemptsListener != null) {
            RULE_ATTEMPTS_LOGGER.debug("Rule Attempts Info for " + this.getClass().getSimpleName());
            RULE_ATTEMPTS_LOGGER.debug(this.ruleAttemptsListener.dump());
        }
    }

    protected void fireRule(RelOptRuleCall ruleCall) {
        RelOptListener.RuleAttemptedEvent event;
        this.checkCancel();
        assert (ruleCall.getRule().matches(ruleCall));
        if (this.isRuleExcluded(ruleCall.getRule())) {
            LOGGER.debug("call#{}: Rule [{}] not fired due to exclusion filter", (Object)ruleCall.id, (Object)ruleCall.getRule());
            return;
        }
        if (ruleCall.isRuleExcluded()) {
            LOGGER.debug("call#{}: Rule [{}] not fired due to exclusion hint", (Object)ruleCall.id, (Object)ruleCall.getRule());
            return;
        }
        if (this.listener != null) {
            event = new RelOptListener.RuleAttemptedEvent(this, (RelNode)ruleCall.rel(0), ruleCall, true);
            this.listener.ruleAttempted(event);
        }
        ruleCall.getRule().onMatch(ruleCall);
        if (this.listener != null) {
            event = new RelOptListener.RuleAttemptedEvent(this, (RelNode)ruleCall.rel(0), ruleCall, false);
            this.listener.ruleAttempted(event);
        }
    }

    protected void notifyTransformation(RelOptRuleCall ruleCall, RelNode newRel, boolean before) {
        if (this.listener != null) {
            RelOptListener.RuleProductionEvent event = new RelOptListener.RuleProductionEvent(this, newRel, ruleCall, before);
            this.listener.ruleProductionSucceeded(event);
        }
    }

    protected void notifyChosen(RelNode rel) {
        LOGGER.debug("For final plan, using {}", (Object)rel);
        if (this.listener != null) {
            RelOptListener.RelChosenEvent event = new RelOptListener.RelChosenEvent(this, rel);
            this.listener.relChosen(event);
        }
    }

    protected void notifyEquivalence(RelNode rel, Object equivalenceClass, boolean physical) {
        if (this.listener != null) {
            RelOptListener.RelEquivalenceEvent event = new RelOptListener.RelEquivalenceEvent(this, rel, equivalenceClass, physical);
            this.listener.relEquivalenceFound(event);
        }
    }

    protected void notifyDiscard(RelNode rel) {
        if (this.listener != null) {
            RelOptListener.RelDiscardedEvent event = new RelOptListener.RelDiscardedEvent(this, rel);
            this.listener.relDiscarded(event);
        }
    }

    @Pure
    public @Nullable RelOptListener getListener() {
        return this.listener;
    }

    public Iterable<Class<? extends RelNode>> subClasses(Class<? extends RelNode> clazz) {
        return Util.filter(this.classes, c -> {
            if (c == RelSubset.class) {
                return c == clazz;
            }
            return clazz.isAssignableFrom((Class<?>)c);
        });
    }

    private static class RuleAttemptsListener
    implements RelOptListener {
        private long beforeTimestamp;
        private final Map<String, Pair<Long, Long>> ruleAttempts = new HashMap<String, Pair<Long, Long>>();

        RuleAttemptsListener() {
        }

        @Override
        public void relEquivalenceFound(RelOptListener.RelEquivalenceEvent event) {
        }

        @Override
        public void ruleAttempted(RelOptListener.RuleAttemptedEvent event) {
            if (event.isBefore()) {
                this.beforeTimestamp = System.nanoTime();
            } else {
                long elapsed = (System.nanoTime() - this.beforeTimestamp) / 1000L;
                String rule = event.getRuleCall().getRule().toString();
                this.ruleAttempts.compute(rule, (k, p) -> p == null ? Pair.of(1L, elapsed) : Pair.of((Long)p.left + 1L, (Long)p.right + elapsed));
            }
        }

        @Override
        public void ruleProductionSucceeded(RelOptListener.RuleProductionEvent event) {
        }

        @Override
        public void relDiscarded(RelOptListener.RelDiscardedEvent event) {
        }

        @Override
        public void relChosen(RelOptListener.RelChosenEvent event) {
        }

        public String dump() {
            ArrayList<Map.Entry<String, Pair<Long, Long>>> list = new ArrayList<Map.Entry<String, Pair<Long, Long>>>(this.ruleAttempts.entrySet());
            list.sort((left, right) -> {
                int res = ((Long)((Pair)right.getValue()).left).compareTo((Long)((Pair)left.getValue()).left);
                if (res == 0) {
                    res = ((Long)((Pair)right.getValue()).right).compareTo((Long)((Pair)left.getValue()).right);
                }
                if (res == 0) {
                    res = ((String)left.getKey()).compareTo((String)right.getKey());
                }
                return res;
            });
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(Locale.ROOT, "%n%-60s%20s%20s%n", "Rules", "Attempts", "Time (us)"));
            NumberFormat usFormat = NumberFormat.getNumberInstance(Locale.US);
            long totalAttempts = 0L;
            long totalTime = 0L;
            for (Map.Entry entry : list) {
                sb.append(String.format(Locale.ROOT, "%-60s%20s%20s%n", entry.getKey(), usFormat.format(((Pair)entry.getValue()).left), usFormat.format(((Pair)entry.getValue()).right)));
                totalAttempts += ((Long)((Pair)entry.getValue()).left).longValue();
                totalTime += ((Long)((Pair)entry.getValue()).right).longValue();
            }
            sb.append(String.format(Locale.ROOT, "%-60s%20s%20s%n", "* Total", usFormat.format(totalAttempts), usFormat.format(totalTime)));
            return sb.toString();
        }
    }
}

