/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.tuple;

import com.yahoo.sketches.tuple.ArrayOfDoublesSketchIterator;
import java.util.Arrays;

final class HeapArrayOfDoublesSketchIterator
implements ArrayOfDoublesSketchIterator {
    private long[] keys_;
    private double[] values_;
    private int numValues_;
    private int i_;

    HeapArrayOfDoublesSketchIterator(long[] keys2, double[] values2, int numValues) {
        this.keys_ = keys2;
        this.values_ = values2;
        this.numValues_ = numValues;
        this.i_ = -1;
    }

    @Override
    public boolean next() {
        if (this.keys_ == null) {
            return false;
        }
        ++this.i_;
        while (this.i_ < this.keys_.length) {
            if (this.keys_[this.i_] != 0L) {
                return true;
            }
            ++this.i_;
        }
        return false;
    }

    @Override
    public long getKey() {
        return this.keys_[this.i_];
    }

    @Override
    public double[] getValues() {
        if (this.numValues_ == 1) {
            return new double[]{this.values_[this.i_]};
        }
        return Arrays.copyOfRange(this.values_, this.i_ * this.numValues_, (this.i_ + 1) * this.numValues_);
    }
}

