/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.OutputInt;

public class UnicodeSetSpanner {
    private final UnicodeSet unicodeSet;

    public UnicodeSetSpanner(UnicodeSet source2) {
        this.unicodeSet = source2;
    }

    public UnicodeSet getUnicodeSet() {
        return this.unicodeSet;
    }

    public boolean equals(Object other) {
        return other instanceof UnicodeSetSpanner && this.unicodeSet.equals(((UnicodeSetSpanner)other).unicodeSet);
    }

    public int hashCode() {
        return this.unicodeSet.hashCode();
    }

    public int countIn(CharSequence sequence2) {
        return this.countIn(sequence2, CountMethod.MIN_ELEMENTS, UnicodeSet.SpanCondition.SIMPLE);
    }

    public int countIn(CharSequence sequence2, CountMethod countMethod) {
        return this.countIn(sequence2, countMethod, UnicodeSet.SpanCondition.SIMPLE);
    }

    public int countIn(CharSequence sequence2, CountMethod countMethod, UnicodeSet.SpanCondition spanCondition) {
        int endOfSpan;
        int count = 0;
        int start = 0;
        UnicodeSet.SpanCondition skipSpan = spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED ? UnicodeSet.SpanCondition.SIMPLE : UnicodeSet.SpanCondition.NOT_CONTAINED;
        int length = sequence2.length();
        OutputInt spanCount = null;
        while (start != length && (endOfSpan = this.unicodeSet.span(sequence2, start, skipSpan)) != length) {
            if (countMethod == CountMethod.WHOLE_SPAN) {
                start = this.unicodeSet.span(sequence2, endOfSpan, spanCondition);
                ++count;
                continue;
            }
            if (spanCount == null) {
                spanCount = new OutputInt();
            }
            start = this.unicodeSet.spanAndCount(sequence2, endOfSpan, spanCondition, spanCount);
            count += spanCount.value;
        }
        return count;
    }

    public String deleteFrom(CharSequence sequence2) {
        return this.replaceFrom(sequence2, "", CountMethod.WHOLE_SPAN, UnicodeSet.SpanCondition.SIMPLE);
    }

    public String deleteFrom(CharSequence sequence2, UnicodeSet.SpanCondition spanCondition) {
        return this.replaceFrom(sequence2, "", CountMethod.WHOLE_SPAN, spanCondition);
    }

    public String replaceFrom(CharSequence sequence2, CharSequence replacement) {
        return this.replaceFrom(sequence2, replacement, CountMethod.MIN_ELEMENTS, UnicodeSet.SpanCondition.SIMPLE);
    }

    public String replaceFrom(CharSequence sequence2, CharSequence replacement, CountMethod countMethod) {
        return this.replaceFrom(sequence2, replacement, countMethod, UnicodeSet.SpanCondition.SIMPLE);
    }

    public String replaceFrom(CharSequence sequence2, CharSequence replacement, CountMethod countMethod, UnicodeSet.SpanCondition spanCondition) {
        UnicodeSet.SpanCondition copySpan = spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED ? UnicodeSet.SpanCondition.SIMPLE : UnicodeSet.SpanCondition.NOT_CONTAINED;
        boolean remove = replacement.length() == 0;
        StringBuilder result2 = new StringBuilder();
        int length = sequence2.length();
        OutputInt spanCount = null;
        int endCopy = 0;
        while (endCopy != length) {
            int endModify;
            if (countMethod == CountMethod.WHOLE_SPAN) {
                endModify = this.unicodeSet.span(sequence2, endCopy, spanCondition);
            } else {
                if (spanCount == null) {
                    spanCount = new OutputInt();
                }
                endModify = this.unicodeSet.spanAndCount(sequence2, endCopy, spanCondition, spanCount);
            }
            if (!remove && endModify != 0) {
                if (countMethod == CountMethod.WHOLE_SPAN) {
                    result2.append(replacement);
                } else {
                    for (int i = spanCount.value; i > 0; --i) {
                        result2.append(replacement);
                    }
                }
            }
            if (endModify == length) break;
            endCopy = this.unicodeSet.span(sequence2, endModify, copySpan);
            result2.append(sequence2.subSequence(endModify, endCopy));
        }
        return result2.toString();
    }

    public CharSequence trim(CharSequence sequence2) {
        return this.trim(sequence2, TrimOption.BOTH, UnicodeSet.SpanCondition.SIMPLE);
    }

    public CharSequence trim(CharSequence sequence2, TrimOption trimOption) {
        return this.trim(sequence2, trimOption, UnicodeSet.SpanCondition.SIMPLE);
    }

    public CharSequence trim(CharSequence sequence2, TrimOption trimOption, UnicodeSet.SpanCondition spanCondition) {
        int endLeadContained;
        int length = sequence2.length();
        if (trimOption != TrimOption.TRAILING) {
            endLeadContained = this.unicodeSet.span(sequence2, spanCondition);
            if (endLeadContained == length) {
                return "";
            }
        } else {
            endLeadContained = 0;
        }
        int startTrailContained = trimOption != TrimOption.LEADING ? this.unicodeSet.spanBack(sequence2, spanCondition) : length;
        return endLeadContained == 0 && startTrailContained == length ? sequence2 : sequence2.subSequence(endLeadContained, startTrailContained);
    }

    public static enum TrimOption {
        LEADING,
        BOTH,
        TRAILING;

    }

    public static enum CountMethod {
        WHOLE_SPAN,
        MIN_ELEMENTS;

    }
}

