/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core.ranges;

import com.google.uzaygezen.core.BigIntegerContent;
import com.google.uzaygezen.core.Pow2LengthBitSetRange;
import com.google.uzaygezen.core.ranges.BigIntegerRange;
import com.google.uzaygezen.core.ranges.RangeHome;
import java.math.BigInteger;
import java.util.List;

public enum BigIntegerRangeHome implements RangeHome<BigInteger, BigIntegerContent, BigIntegerRange>
{
    INSTANCE;


    @Override
    public BigIntegerRange of(BigInteger start, BigInteger end) {
        return BigIntegerRange.of(start, end);
    }

    @Override
    public BigIntegerRange toRange(Pow2LengthBitSetRange bitSetRange) {
        BigInteger inclusiveStart = bitSetRange.getStart().toBigInteger();
        BigInteger delta = BigInteger.ONE.shiftLeft(bitSetRange.getLevel());
        BigInteger exclusiveEnd = inclusiveStart.add(delta);
        return BigIntegerRange.of(inclusiveStart, exclusiveEnd);
    }

    @Override
    public BigIntegerContent overlap(List<BigIntegerRange> x, List<BigIntegerRange> y) {
        BigInteger overlap = BigIntegerRange.overlap(x, y);
        return new BigIntegerContent(overlap);
    }
}

