/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.http.util;

import com.alibaba.druid.support.http.util.IPAddress;

public class IPRange {
    private IPAddress ipAddress = null;
    private IPAddress ipSubnetMask = null;
    private int extendedNetworkPrefix = 0;

    public IPRange(String range) {
        this.parseRange(range);
    }

    public final IPAddress getIPAddress() {
        return this.ipAddress;
    }

    public final IPAddress getIPSubnetMask() {
        return this.ipSubnetMask;
    }

    public final int getExtendedNetworkPrefix() {
        return this.extendedNetworkPrefix;
    }

    public String toString() {
        return this.ipAddress.toString() + "/" + this.extendedNetworkPrefix;
    }

    final void parseRange(String range) {
        block7: {
            if (range == null) {
                throw new IllegalArgumentException("Invalid IP range");
            }
            int index = range.indexOf(47);
            String subnetStr = null;
            if (index == -1) {
                this.ipAddress = new IPAddress(range);
            } else {
                this.ipAddress = new IPAddress(range.substring(0, index));
                subnetStr = range.substring(index + 1);
            }
            try {
                if (subnetStr != null) {
                    this.extendedNetworkPrefix = Integer.parseInt(subnetStr);
                    if (this.extendedNetworkPrefix < 0 || this.extendedNetworkPrefix > 32) {
                        throw new IllegalArgumentException("Invalid IP range [" + range + "]");
                    }
                    this.ipSubnetMask = this.computeMaskFromNetworkPrefix(this.extendedNetworkPrefix);
                }
            }
            catch (NumberFormatException ex) {
                this.ipSubnetMask = new IPAddress(subnetStr);
                this.extendedNetworkPrefix = this.computeNetworkPrefixFromMask(this.ipSubnetMask);
                if (this.extendedNetworkPrefix != -1) break block7;
                throw new IllegalArgumentException("Invalid IP range [" + range + "]", ex);
            }
        }
    }

    private int computeNetworkPrefixFromMask(IPAddress mask) {
        int result2 = 0;
        int tmp = mask.getIPAddress();
        while ((tmp & 1) == 1) {
            ++result2;
            tmp >>>= 1;
        }
        if (tmp != 0) {
            return -1;
        }
        return result2;
    }

    public static String toDecimalString(String inBinaryIpAddress) {
        StringBuilder decimalIp = new StringBuilder();
        String[] binary = new String[4];
        int i = 0;
        int c = 0;
        while (i < 32) {
            binary[c] = inBinaryIpAddress.substring(i, i + 8);
            int octet = Integer.parseInt(binary[c], 2);
            decimalIp.append(octet);
            if (c < 3) {
                decimalIp.append('.');
            }
            i += 8;
            ++c;
        }
        return decimalIp.toString();
    }

    private IPAddress computeMaskFromNetworkPrefix(int prefix) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            if (i < prefix) {
                str.append("1");
                continue;
            }
            str.append("0");
        }
        String decimalString = IPRange.toDecimalString(str.toString());
        return new IPAddress(decimalString);
    }

    public boolean isIPAddressInRange(IPAddress address) {
        int result2;
        if (this.ipSubnetMask == null) {
            return this.ipAddress.equals(address);
        }
        int result1 = address.getIPAddress() & this.ipSubnetMask.getIPAddress();
        return result1 == (result2 = this.ipAddress.getIPAddress() & this.ipSubnetMask.getIPAddress());
    }
}

