/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.impl.BasicAlgorithmPolicyConfiguration;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;

public class BasicSignatureSigningConfiguration
extends BasicAlgorithmPolicyConfiguration
implements SignatureSigningConfiguration {
    @Nonnull
    private List<Credential> signingCredentials = CollectionSupport.emptyList();
    @Nonnull
    private List<String> signatureAlgorithms = CollectionSupport.emptyList();
    @Nonnull
    private List<String> signatureReferenceDigestMethods = CollectionSupport.emptyList();
    @Nullable
    private String signatureReferenceCanonicalizationAlgorithm;
    @Nullable
    private String signatureCanonicalization;
    @Nullable
    private Integer signatureHMACOutputLength;
    @Nullable
    private NamedKeyInfoGeneratorManager keyInfoGeneratorManager;

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public List<Credential> getSigningCredentials() {
        return this.signingCredentials;
    }

    @Nonnull
    public BasicSignatureSigningConfiguration setSigningCredentials(@Nullable List<Credential> credentials) {
        this.signingCredentials = credentials == null ? CollectionSupport.emptyList() : CollectionSupport.copyToList(credentials);
        return this;
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public List<String> getSignatureAlgorithms() {
        return this.signatureAlgorithms;
    }

    @Nonnull
    public BasicSignatureSigningConfiguration setSignatureAlgorithms(@Nullable List<String> algorithms) {
        this.signatureAlgorithms = algorithms == null ? CollectionSupport.emptyList() : CollectionSupport.copyToList(StringSupport.normalizeStringCollection(algorithms));
        return this;
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public List<String> getSignatureReferenceDigestMethods() {
        return this.signatureReferenceDigestMethods;
    }

    @Nonnull
    public BasicSignatureSigningConfiguration setSignatureReferenceDigestMethods(@Nullable List<String> algorithms) {
        this.signatureReferenceDigestMethods = algorithms == null ? CollectionSupport.emptyList() : CollectionSupport.copyToList(StringSupport.normalizeStringCollection(algorithms));
        return this;
    }

    @Override
    @Nullable
    public String getSignatureReferenceCanonicalizationAlgorithm() {
        return this.signatureReferenceCanonicalizationAlgorithm;
    }

    @Nonnull
    public BasicSignatureSigningConfiguration setSignatureReferenceCanonicalizationAlgorithm(@Nullable String uri) {
        this.signatureReferenceCanonicalizationAlgorithm = StringSupport.trimOrNull(uri);
        return this;
    }

    @Override
    @Nullable
    public String getSignatureCanonicalizationAlgorithm() {
        return this.signatureCanonicalization;
    }

    @Nonnull
    public BasicSignatureSigningConfiguration setSignatureCanonicalizationAlgorithm(@Nullable String algorithmURI) {
        this.signatureCanonicalization = StringSupport.trimOrNull(algorithmURI);
        return this;
    }

    @Override
    @Nullable
    public Integer getSignatureHMACOutputLength() {
        return this.signatureHMACOutputLength;
    }

    @Nonnull
    public BasicSignatureSigningConfiguration setSignatureHMACOutputLength(@Nullable Integer length) {
        this.signatureHMACOutputLength = length;
        return this;
    }

    @Override
    @Nullable
    public NamedKeyInfoGeneratorManager getKeyInfoGeneratorManager() {
        return this.keyInfoGeneratorManager;
    }

    @Nonnull
    public BasicSignatureSigningConfiguration setKeyInfoGeneratorManager(@Nullable NamedKeyInfoGeneratorManager keyInfoManager) {
        this.keyInfoGeneratorManager = keyInfoManager;
        return this;
    }
}

