/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla;

import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientManager;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.netbeans.modules.bugtracking.commons.SimpleIssueFinder;
import org.netbeans.modules.bugtracking.issuetable.IssueNode;
import org.netbeans.modules.bugtracking.spi.BugtrackingSupport;
import org.netbeans.modules.bugtracking.spi.IssueFinder;
import org.netbeans.modules.bugtracking.spi.IssuePriorityInfo;
import org.netbeans.modules.bugtracking.spi.IssuePriorityProvider;
import org.netbeans.modules.bugtracking.spi.IssueProvider;
import org.netbeans.modules.bugtracking.spi.IssueScheduleInfo;
import org.netbeans.modules.bugtracking.spi.IssueScheduleProvider;
import org.netbeans.modules.bugtracking.spi.IssueStatusProvider;
import org.netbeans.modules.bugtracking.spi.QueryProvider;
import org.netbeans.modules.bugtracking.spi.RepositoryProvider;
import org.netbeans.modules.bugzilla.BugzillaIssueProvider;
import org.netbeans.modules.bugzilla.BugzillaQueryProvider;
import org.netbeans.modules.bugzilla.BugzillaRepositoryProvider;
import org.netbeans.modules.bugzilla.MylynRepositoryConnectorProvider;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.mylyn.util.MylynSupport;
import org.openide.util.RequestProcessor;

public class Bugzilla {
    private BugzillaRepositoryConnector brc = MylynRepositoryConnectorProvider.getInstance().getConnector();
    private static Bugzilla instance;
    public static final Logger LOG;
    private RequestProcessor rp;
    private BugzillaClientManager clientManager = this.brc.getClientManager();
    private BugtrackingSupport<BugzillaRepository, BugzillaQuery, BugzillaIssue> bf;
    private BugzillaIssueProvider bip;
    private BugzillaQueryProvider bqp;
    private BugzillaRepositoryProvider brp;
    private IssueStatusProvider<BugzillaRepository, BugzillaIssue> sp;
    private IssuePriorityProvider<BugzillaIssue> pp;
    private IssueNode.ChangesProvider<BugzillaIssue> bcp;
    private IssueScheduleProvider<BugzillaIssue> schedulingProvider;
    private IssueFinder issueFinder;

    private Bugzilla() {
        MylynSupport.getInstance().addRepositoryListener((IRepositoryListener)this.clientManager);
    }

    public static synchronized Bugzilla getInstance() {
        if (instance == null) {
            instance = new Bugzilla();
        }
        return instance;
    }

    static synchronized void init() {
        Bugzilla.getInstance();
    }

    public BugzillaRepositoryConnector getRepositoryConnector() {
        return this.brc;
    }

    public RepositoryConfiguration getRepositoryConfiguration(BugzillaRepository repository, boolean forceRefresh) throws CoreException, MalformedURLException {
        this.getClient(repository);
        RepositoryConfiguration rc = this.brc.getRepositoryConfiguration(repository.getTaskRepository(), forceRefresh, (IProgressMonitor)new NullProgressMonitor());
        return rc;
    }

    public BugzillaClient getClient(BugzillaRepository repository) throws MalformedURLException, CoreException {
        return this.clientManager.getClient(repository.getTaskRepository(), (IProgressMonitor)new NullProgressMonitor());
    }

    public final RequestProcessor getRequestProcessor() {
        if (this.rp == null) {
            this.rp = new RequestProcessor("Bugzilla", 1, true);
        }
        return this.rp;
    }

    public BugtrackingSupport<BugzillaRepository, BugzillaQuery, BugzillaIssue> getBugtrackingFactory() {
        if (this.bf == null) {
            this.bf = new BugtrackingSupport((RepositoryProvider)this.getRepositoryProvider(), (QueryProvider)this.getQueryProvider(), (IssueProvider)this.getIssueProvider());
        }
        return this.bf;
    }

    public BugzillaIssueProvider getIssueProvider() {
        if (this.bip == null) {
            this.bip = new BugzillaIssueProvider();
        }
        return this.bip;
    }

    public BugzillaQueryProvider getQueryProvider() {
        if (this.bqp == null) {
            this.bqp = new BugzillaQueryProvider();
        }
        return this.bqp;
    }

    public BugzillaRepositoryProvider getRepositoryProvider() {
        if (this.brp == null) {
            this.brp = new BugzillaRepositoryProvider();
        }
        return this.brp;
    }

    public IssueStatusProvider<BugzillaRepository, BugzillaIssue> getStatusProvider() {
        if (this.sp == null) {
            this.sp = new IssueStatusProvider<BugzillaRepository, BugzillaIssue>(){

                public IssueStatusProvider.Status getStatus(BugzillaIssue issue) {
                    return issue.getStatus();
                }

                public void setSeenIncoming(BugzillaIssue issue, boolean uptodate) {
                    issue.setUpToDate(uptodate);
                }

                public void removePropertyChangeListener(BugzillaIssue issue, PropertyChangeListener listener) {
                    issue.removePropertyChangeListener(listener);
                }

                public void addPropertyChangeListener(BugzillaIssue issue, PropertyChangeListener listener) {
                    issue.addPropertyChangeListener(listener);
                }

                public Collection<BugzillaIssue> getUnsubmittedIssues(BugzillaRepository r) {
                    return r.getUnsubmittedIssues();
                }

                public void discardOutgoing(BugzillaIssue i) {
                    i.discardLocalEdits();
                }

                public boolean submit(BugzillaIssue data) {
                    return data.submitAndRefresh();
                }
            };
        }
        return this.sp;
    }

    public IssuePriorityProvider<BugzillaIssue> createPriorityProvider(final BugzillaRepository repository) {
        return new IssuePriorityProvider<BugzillaIssue>(){
            private IssuePriorityInfo[] infos;
            final /* synthetic */ Bugzilla this$0;
            {
                this.this$0 = this$0;
            }

            public String getPriorityID(BugzillaIssue i) {
                return i.getPriority();
            }

            public synchronized IssuePriorityInfo[] getPriorityInfos() {
                if (this.infos == null) {
                    List<String> priorities = repository.getConfiguration().getPriorities();
                    this.infos = new IssuePriorityInfo[priorities.size()];
                    for (int i = 0; i < priorities.size(); ++i) {
                        String p = priorities.get(i);
                        this.infos[i] = new IssuePriorityInfo(p, p);
                    }
                }
                return this.infos;
            }
        };
    }

    public IssueScheduleProvider<BugzillaIssue> getSchedulingProvider() {
        if (this.schedulingProvider == null) {
            this.schedulingProvider = new IssueScheduleProvider<BugzillaIssue>(){

                public void setSchedule(BugzillaIssue i, IssueScheduleInfo date) {
                    i.setTaskScheduleDate(date, true);
                }

                public Date getDueDate(BugzillaIssue i) {
                    return i.getPersistentDueDate();
                }

                public IssueScheduleInfo getSchedule(BugzillaIssue i) {
                    return i.getPersistentScheduleInfo();
                }
            };
        }
        return this.schedulingProvider;
    }

    public IssueNode.ChangesProvider<BugzillaIssue> getChangesProvider() {
        if (this.bcp == null) {
            this.bcp = new IssueNode.ChangesProvider<BugzillaIssue>(){

                public String getRecentChanges(BugzillaIssue i) {
                    return i.getRecentChanges();
                }
            };
        }
        return this.bcp;
    }

    public IssueFinder getBugzillaIssueFinder() {
        if (this.issueFinder == null) {
            this.issueFinder = new IssueFinder(){

                public int[] getIssueSpans(CharSequence text) {
                    return SimpleIssueFinder.getInstance().getIssueSpans(text);
                }

                public String getIssueId(String issueHyperlinkText) {
                    return SimpleIssueFinder.getInstance().getIssueId(issueHyperlinkText);
                }
            };
        }
        return this.issueFinder;
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.bugzilla.Bugzilla");
    }
}

