/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.model;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import jdk.jshell.DeclarationSnippet;
import jdk.jshell.ImportSnippet;
import jdk.jshell.JShell;
import jdk.jshell.Snippet;
import org.netbeans.lib.nbjshell.SnippetWrapping;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.modules.jshell.model.Rng;
import org.netbeans.modules.jshell.parsing.SnippetRegistry;
import org.openide.filesystems.FileObject;

public final class SnippetHandle {
    final Reference<ConsoleSection> section;
    final Rng[] fragments;
    final SnippetWrapping wrapping;
    final boolean transientSnippet;
    private SnippetRegistry registry;
    private FileObject snippetFile;

    SnippetHandle(ConsoleSection section, Rng[] fragments, SnippetWrapping wrapping, boolean transientSnippet) {
        this.section = new WeakReference<ConsoleSection>(section);
        this.fragments = fragments;
        this.wrapping = wrapping;
        this.transientSnippet = transientSnippet;
    }

    SnippetHandle(SnippetRegistry registry, ConsoleSection section, Rng[] fragments, SnippetWrapping wrapping, boolean transientSnippet) {
        this.registry = registry;
        this.section = new WeakReference<ConsoleSection>(section);
        this.fragments = fragments;
        this.wrapping = wrapping;
        this.transientSnippet = transientSnippet;
    }

    SnippetHandle(ConsoleSection section, Rng[] fragments, SnippetWrapping wrapping) {
        this.section = new WeakReference<ConsoleSection>(section);
        this.fragments = fragments;
        this.wrapping = wrapping;
        this.transientSnippet = true;
    }

    public JShell getState() {
        return this.registry.getState();
    }

    public boolean isTransient() {
        return this.transientSnippet;
    }

    public int start() {
        return this.fragments == null ? 0 : this.fragments[0].start;
    }

    public int end() {
        return this.fragments == null ? this.wrapping.getSource().length() : this.fragments[this.fragments.length - 1].end;
    }

    public String getWrappedCode() {
        return this.wrapping.getCode();
    }

    public int getWrappedPosition(int pos) {
        return this.wrapping.getWrappedPosition(pos);
    }

    public Snippet getSnippet() {
        return this.wrapping.getSnippet();
    }

    public ConsoleSection getSection() {
        return this.section.get();
    }

    public Snippet.Kind getKind() {
        return this.wrapping.getSnippetKind();
    }

    public String getSource() {
        return this.wrapping.getSource();
    }

    public Rng[] getFragments() {
        return this.fragments;
    }

    public Snippet.Status getStatus() {
        return this.wrapping.getStatus();
    }

    public String getClassName() {
        return this.wrapping.getClassName();
    }

    public synchronized FileObject getFile() throws IOException {
        if (this.snippetFile != null) {
            return this.snippetFile;
        }
        if (this.registry == null) {
            throw new IOException("Cannot create");
        }
        return this.registry.snippetFile(this, 0);
    }

    synchronized void setFile(FileObject f) {
        this.snippetFile = f;
    }

    public String toString() {
        if (this.section == null) {
            return "SH[ <none>, wrap: " + String.valueOf(this.wrapping) + "]";
        }
        return "SH[" + String.valueOf(this.section) + ": " + (this.fragments == null ? "<none>" : Arrays.asList(this.fragments).toString()) + ", wrap: " + String.valueOf(this.wrapping) + "]";
    }

    public String text() {
        Snippet sn = this.wrapping.getSnippet();
        if (sn == null) {
            return null;
        }
        switch (this.getKind()) {
            case IMPORT: {
                return ((ImportSnippet)sn).fullname();
            }
            case METHOD: 
            case TYPE_DECL: 
            case VAR: {
                return ((DeclarationSnippet)sn).name();
            }
            case EXPRESSION: 
            case STATEMENT: {
                return sn.source();
            }
            case ERRONEOUS: {
                return null;
            }
        }
        throw new AssertionError((Object)this.getKind().name());
    }

    public boolean contains(int position) {
        return this.fragments[0].start <= position && this.fragments[this.fragments.length - 1].end >= position;
    }
}

