/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateExternalBackupJobDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="dbVersion")
    private final String dbVersion;
    @JsonProperty(value="dbName")
    private final String dbName;
    @JsonProperty(value="dbUniqueName")
    private final String dbUniqueName;
    @JsonProperty(value="pdbName")
    private final String pdbName;
    @JsonProperty(value="externalDatabaseIdentifier")
    private final Long externalDatabaseIdentifier;
    @JsonProperty(value="characterSet")
    private final String characterSet;
    @JsonProperty(value="ncharacterSet")
    private final String ncharacterSet;
    @JsonProperty(value="databaseMode")
    private final DatabaseMode databaseMode;
    @JsonProperty(value="databaseEdition")
    private final DatabaseEdition databaseEdition;

    @Deprecated
    @ConstructorProperties(value={"availabilityDomain", "compartmentId", "displayName", "dbVersion", "dbName", "dbUniqueName", "pdbName", "externalDatabaseIdentifier", "characterSet", "ncharacterSet", "databaseMode", "databaseEdition"})
    public CreateExternalBackupJobDetails(String availabilityDomain, String compartmentId, String displayName, String dbVersion, String dbName, String dbUniqueName, String pdbName, Long externalDatabaseIdentifier, String characterSet, String ncharacterSet, DatabaseMode databaseMode, DatabaseEdition databaseEdition) {
        this.availabilityDomain = availabilityDomain;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.dbVersion = dbVersion;
        this.dbName = dbName;
        this.dbUniqueName = dbUniqueName;
        this.pdbName = pdbName;
        this.externalDatabaseIdentifier = externalDatabaseIdentifier;
        this.characterSet = characterSet;
        this.ncharacterSet = ncharacterSet;
        this.databaseMode = databaseMode;
        this.databaseEdition = databaseEdition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public String getPdbName() {
        return this.pdbName;
    }

    public Long getExternalDatabaseIdentifier() {
        return this.externalDatabaseIdentifier;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public String getNcharacterSet() {
        return this.ncharacterSet;
    }

    public DatabaseMode getDatabaseMode() {
        return this.databaseMode;
    }

    public DatabaseEdition getDatabaseEdition() {
        return this.databaseEdition;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateExternalBackupJobDetails(");
        sb.append("super=").append(super.toString());
        sb.append("availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", dbVersion=").append(String.valueOf(this.dbVersion));
        sb.append(", dbName=").append(String.valueOf(this.dbName));
        sb.append(", dbUniqueName=").append(String.valueOf(this.dbUniqueName));
        sb.append(", pdbName=").append(String.valueOf(this.pdbName));
        sb.append(", externalDatabaseIdentifier=").append(String.valueOf(this.externalDatabaseIdentifier));
        sb.append(", characterSet=").append(String.valueOf(this.characterSet));
        sb.append(", ncharacterSet=").append(String.valueOf(this.ncharacterSet));
        sb.append(", databaseMode=").append(String.valueOf((Object)this.databaseMode));
        sb.append(", databaseEdition=").append(String.valueOf((Object)this.databaseEdition));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateExternalBackupJobDetails)) {
            return false;
        }
        CreateExternalBackupJobDetails other = (CreateExternalBackupJobDetails)((Object)o);
        return Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.dbVersion, other.dbVersion) && Objects.equals(this.dbName, other.dbName) && Objects.equals(this.dbUniqueName, other.dbUniqueName) && Objects.equals(this.pdbName, other.pdbName) && Objects.equals(this.externalDatabaseIdentifier, other.externalDatabaseIdentifier) && Objects.equals(this.characterSet, other.characterSet) && Objects.equals(this.ncharacterSet, other.ncharacterSet) && Objects.equals((Object)this.databaseMode, (Object)other.databaseMode) && Objects.equals((Object)this.databaseEdition, (Object)other.databaseEdition) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.dbVersion == null ? 43 : this.dbVersion.hashCode());
        result = result * 59 + (this.dbName == null ? 43 : this.dbName.hashCode());
        result = result * 59 + (this.dbUniqueName == null ? 43 : this.dbUniqueName.hashCode());
        result = result * 59 + (this.pdbName == null ? 43 : this.pdbName.hashCode());
        result = result * 59 + (this.externalDatabaseIdentifier == null ? 43 : this.externalDatabaseIdentifier.hashCode());
        result = result * 59 + (this.characterSet == null ? 43 : this.characterSet.hashCode());
        result = result * 59 + (this.ncharacterSet == null ? 43 : this.ncharacterSet.hashCode());
        result = result * 59 + (this.databaseMode == null ? 43 : this.databaseMode.hashCode());
        result = result * 59 + (this.databaseEdition == null ? 43 : this.databaseEdition.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DatabaseEdition implements BmcEnum
    {
        StandardEdition("STANDARD_EDITION"),
        EnterpriseEdition("ENTERPRISE_EDITION"),
        EnterpriseEditionHighPerformance("ENTERPRISE_EDITION_HIGH_PERFORMANCE"),
        EnterpriseEditionExtremePerformance("ENTERPRISE_EDITION_EXTREME_PERFORMANCE");

        private final String value;
        private static Map<String, DatabaseEdition> map;

        private DatabaseEdition(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseEdition create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DatabaseEdition: " + key);
        }

        static {
            map = new HashMap<String, DatabaseEdition>();
            for (DatabaseEdition v : DatabaseEdition.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DatabaseMode implements BmcEnum
    {
        Si("SI"),
        Rac("RAC");

        private final String value;
        private static Map<String, DatabaseMode> map;

        private DatabaseMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DatabaseMode: " + key);
        }

        static {
            map = new HashMap<String, DatabaseMode>();
            for (DatabaseMode v : DatabaseMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="dbVersion")
        private String dbVersion;
        @JsonProperty(value="dbName")
        private String dbName;
        @JsonProperty(value="dbUniqueName")
        private String dbUniqueName;
        @JsonProperty(value="pdbName")
        private String pdbName;
        @JsonProperty(value="externalDatabaseIdentifier")
        private Long externalDatabaseIdentifier;
        @JsonProperty(value="characterSet")
        private String characterSet;
        @JsonProperty(value="ncharacterSet")
        private String ncharacterSet;
        @JsonProperty(value="databaseMode")
        private DatabaseMode databaseMode;
        @JsonProperty(value="databaseEdition")
        private DatabaseEdition databaseEdition;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder dbVersion(String dbVersion) {
            this.dbVersion = dbVersion;
            this.__explicitlySet__.add("dbVersion");
            return this;
        }

        public Builder dbName(String dbName) {
            this.dbName = dbName;
            this.__explicitlySet__.add("dbName");
            return this;
        }

        public Builder dbUniqueName(String dbUniqueName) {
            this.dbUniqueName = dbUniqueName;
            this.__explicitlySet__.add("dbUniqueName");
            return this;
        }

        public Builder pdbName(String pdbName) {
            this.pdbName = pdbName;
            this.__explicitlySet__.add("pdbName");
            return this;
        }

        public Builder externalDatabaseIdentifier(Long externalDatabaseIdentifier) {
            this.externalDatabaseIdentifier = externalDatabaseIdentifier;
            this.__explicitlySet__.add("externalDatabaseIdentifier");
            return this;
        }

        public Builder characterSet(String characterSet) {
            this.characterSet = characterSet;
            this.__explicitlySet__.add("characterSet");
            return this;
        }

        public Builder ncharacterSet(String ncharacterSet) {
            this.ncharacterSet = ncharacterSet;
            this.__explicitlySet__.add("ncharacterSet");
            return this;
        }

        public Builder databaseMode(DatabaseMode databaseMode) {
            this.databaseMode = databaseMode;
            this.__explicitlySet__.add("databaseMode");
            return this;
        }

        public Builder databaseEdition(DatabaseEdition databaseEdition) {
            this.databaseEdition = databaseEdition;
            this.__explicitlySet__.add("databaseEdition");
            return this;
        }

        public CreateExternalBackupJobDetails build() {
            CreateExternalBackupJobDetails model = new CreateExternalBackupJobDetails(this.availabilityDomain, this.compartmentId, this.displayName, this.dbVersion, this.dbName, this.dbUniqueName, this.pdbName, this.externalDatabaseIdentifier, this.characterSet, this.ncharacterSet, this.databaseMode, this.databaseEdition);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateExternalBackupJobDetails model) {
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("dbVersion")) {
                this.dbVersion(model.getDbVersion());
            }
            if (model.wasPropertyExplicitlySet("dbName")) {
                this.dbName(model.getDbName());
            }
            if (model.wasPropertyExplicitlySet("dbUniqueName")) {
                this.dbUniqueName(model.getDbUniqueName());
            }
            if (model.wasPropertyExplicitlySet("pdbName")) {
                this.pdbName(model.getPdbName());
            }
            if (model.wasPropertyExplicitlySet("externalDatabaseIdentifier")) {
                this.externalDatabaseIdentifier(model.getExternalDatabaseIdentifier());
            }
            if (model.wasPropertyExplicitlySet("characterSet")) {
                this.characterSet(model.getCharacterSet());
            }
            if (model.wasPropertyExplicitlySet("ncharacterSet")) {
                this.ncharacterSet(model.getNcharacterSet());
            }
            if (model.wasPropertyExplicitlySet("databaseMode")) {
                this.databaseMode(model.getDatabaseMode());
            }
            if (model.wasPropertyExplicitlySet("databaseEdition")) {
                this.databaseEdition(model.getDatabaseEdition());
            }
            return this;
        }
    }
}

