/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.base.semantic;

import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;

public class TokenList {
    private CompilationInfo info;
    private SourcePositions sourcePositions;
    private Document doc;
    private AtomicBoolean cancel;
    private boolean topLevelIsJava;
    private TokenSequence topLevel;
    private TokenSequence ts;

    public TokenList(CompilationInfo info, final Document doc, AtomicBoolean cancel) {
        this.info = info;
        this.doc = doc;
        this.cancel = cancel;
        this.sourcePositions = info.getTrees().getSourcePositions();
        doc.render(new Runnable(){
            final /* synthetic */ TokenList this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.cancel.get()) {
                    return;
                }
                this.this$0.topLevel = TokenHierarchy.get((Document)doc).tokenSequence();
                boolean bl = this.this$0.topLevelIsJava = this.this$0.topLevel.language() == JavaTokenId.language();
                if (this.this$0.topLevelIsJava) {
                    this.this$0.ts = this.this$0.topLevel;
                    this.this$0.ts.moveStart();
                    this.this$0.ts.moveNext();
                }
            }
        });
    }

    public void moveToOffset(long inputOffset) {
        final int offset = this.info.getSnapshot().getOriginalOffset((int)inputOffset);
        if (offset < 0) {
            return;
        }
        this.doc.render(new Runnable(){
            final /* synthetic */ TokenList this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.cancel.get()) {
                    return;
                }
                if (this.this$0.ts != null && !this.this$0.ts.isValid()) {
                    this.this$0.cancel.set(true);
                    return;
                }
                if (this.this$0.topLevelIsJava) {
                    while (this.this$0.ts.offset() < offset) {
                        if (this.this$0.ts.moveNext()) continue;
                        return;
                    }
                } else {
                    ArrayList seqs;
                    Iterator embeddedSeqs = null;
                    if (this.this$0.ts == null) {
                        seqs = new ArrayList(TokenList.embeddedTokenSequences((TokenHierarchy<Document>)TokenHierarchy.get((Document)this.this$0.doc), offset));
                        Collections.reverse(seqs);
                        embeddedSeqs = seqs.iterator();
                        while (embeddedSeqs.hasNext()) {
                            TokenSequence tseq = (TokenSequence)embeddedSeqs.next();
                            if (tseq.language() != JavaTokenId.language()) continue;
                            this.this$0.ts = tseq;
                            break;
                        }
                    }
                    block2: while (this.this$0.ts != null && this.this$0.ts.offset() < offset) {
                        if (this.this$0.ts.moveNext()) continue;
                        this.this$0.ts = null;
                        if (embeddedSeqs == null) {
                            seqs = new ArrayList(TokenList.embeddedTokenSequences((TokenHierarchy<Document>)TokenHierarchy.get((Document)this.this$0.doc), offset));
                            Collections.reverse(seqs);
                            embeddedSeqs = seqs.iterator();
                        }
                        while (embeddedSeqs.hasNext()) {
                            TokenSequence tseq = (TokenSequence)embeddedSeqs.next();
                            if (tseq.language() != JavaTokenId.language()) continue;
                            this.this$0.ts = tseq;
                            continue block2;
                        }
                    }
                }
            }
        });
    }

    public void moveToEnd(Tree t) {
        if (t == null) {
            return;
        }
        long end = this.sourcePositions.getEndPosition(this.info.getCompilationUnit(), t);
        if (end == -1L) {
            return;
        }
        if (t.getKind() == Tree.Kind.ARRAY_TYPE) {
            this.moveToEnd(((ArrayTypeTree)t).getType());
            return;
        }
        this.moveToOffset(end);
    }

    public void moveToEnd(Collection<? extends Tree> trees) {
        if (trees == null) {
            return;
        }
        for (Tree tree : trees) {
            this.moveToEnd(tree);
        }
    }

    public void firstIdentifier(TreePath tp, String name, Map<Tree, List<Token>> tree2Tokens) {
        Token t = this.firstIdentifier(tp, name);
        if (t != null) {
            tree2Tokens.put(tp.getLeaf(), Collections.singletonList(t));
        }
    }

    public Token firstIdentifier(TreePath tp, final String name) {
        final Token[] ret = new Token[]{null};
        this.doc.render(new Runnable(){
            final /* synthetic */ TokenList this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.cancel.get()) {
                    return;
                }
                if (this.this$0.ts != null && !this.this$0.ts.isValid()) {
                    this.this$0.cancel.set(true);
                    return;
                }
                if (this.this$0.ts == null) {
                    return;
                }
                boolean next = true;
                while (this.this$0.ts.token().id() != JavaTokenId.IDENTIFIER && (next = this.this$0.ts.moveNext())) {
                }
                if (next && name.equals(this.this$0.info.getTreeUtilities().decodeIdentifier(this.this$0.ts.token().text()).toString())) {
                    ret[0] = this.this$0.ts.token();
                }
            }
        });
        return ret[0];
    }

    public void identifierHere(final IdentifierTree tree, final Map<Tree, List<Token>> tree2Tokens) {
        this.doc.render(new Runnable(){
            final /* synthetic */ TokenList this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.cancel.get()) {
                    return;
                }
                if (this.this$0.ts != null && !this.this$0.ts.isValid()) {
                    this.this$0.cancel.set(true);
                    return;
                }
                if (this.this$0.ts == null) {
                    return;
                }
                Token t = this.this$0.ts.token();
                if (t.id() == JavaTokenId.IDENTIFIER && tree.getName().toString().equals(this.this$0.info.getTreeUtilities().decodeIdentifier(t.text()).toString())) {
                    tree2Tokens.put(tree, Collections.singletonList(this.this$0.ts.token()));
                }
            }
        });
    }

    public Token currentToken() {
        final Token[] res = new Token[1];
        this.doc.render(new Runnable(){
            final /* synthetic */ TokenList this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.cancel.get()) {
                    return;
                }
                if (this.this$0.ts != null && !this.this$0.ts.isValid()) {
                    this.this$0.cancel.set(true);
                    return;
                }
                if (this.this$0.ts == null) {
                    return;
                }
                res[0] = this.this$0.ts.token();
            }
        });
        return res[0];
    }

    public void moduleNameHere(final ExpressionTree tree, final Map<Tree, List<Token>> tree2Tokens) {
        this.doc.render(new Runnable(){
            final /* synthetic */ TokenList this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.cancel.get()) {
                    return;
                }
                if (this.this$0.ts != null && !this.this$0.ts.isValid()) {
                    this.this$0.cancel.set(true);
                    return;
                }
                if (this.this$0.ts == null) {
                    return;
                }
                this.this$0.ts.move((int)this.this$0.sourcePositions.getStartPosition(this.this$0.info.getCompilationUnit(), tree));
                int end = (int)this.this$0.sourcePositions.getEndPosition(this.this$0.info.getCompilationUnit(), tree);
                ArrayList<Token> tokens = null;
                while (this.this$0.ts.moveNext() && this.this$0.ts.offset() <= end) {
                    Token t = this.this$0.ts.token();
                    if (t.id() != JavaTokenId.IDENTIFIER) continue;
                    if (tokens == null) {
                        tokens = new ArrayList<Token>();
                        tree2Tokens.put(tree, tokens);
                    }
                    tokens.add(t);
                }
            }
        });
    }

    public void moveBefore(final List<? extends Tree> tArgs) {
        this.doc.render(new Runnable(){
            final /* synthetic */ TokenList this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.cancel.get()) {
                    return;
                }
                if (this.this$0.ts != null && !this.this$0.ts.isValid()) {
                    this.this$0.cancel.set(true);
                    return;
                }
                if (this.this$0.ts == null) {
                    return;
                }
                if (!tArgs.isEmpty()) {
                    int offset = (int)this.this$0.info.getTrees().getSourcePositions().getStartPosition(this.this$0.info.getCompilationUnit(), (Tree)tArgs.get(0));
                    offset = this.this$0.info.getSnapshot().getOriginalOffset(offset);
                    if (offset < 0) {
                        return;
                    }
                    while (this.this$0.ts.offset() >= offset) {
                        if (this.this$0.ts.movePrevious()) continue;
                        return;
                    }
                }
            }
        });
    }

    public void moveNext() {
        this.doc.render(new Runnable(){

            @Override
            public void run() {
                if (TokenList.this.cancel.get()) {
                    return;
                }
                if (TokenList.this.ts != null && !TokenList.this.ts.isValid()) {
                    TokenList.this.cancel.set(true);
                    return;
                }
                if (TokenList.this.ts == null) {
                    return;
                }
                TokenList.this.ts.moveNext();
            }
        });
    }

    public int offset() {
        return this.ts != null ? this.ts.offset() : -1;
    }

    public int index() {
        return this.ts != null ? this.ts.index() : -1;
    }

    public void resetToIndex(int index) {
        this.doc.render(() -> {
            if (this.cancel.get()) {
                return;
            }
            if (this.ts == null) {
                return;
            }
            if (!this.ts.isValid()) {
                this.cancel.set(true);
                return;
            }
            this.ts.moveIndex(index);
            this.ts.moveNext();
        });
    }

    private static List<TokenSequence<?>> embeddedTokenSequences(TokenHierarchy<Document> th, int offset) {
        TokenSequence embedded = th.tokenSequence();
        ArrayList sequences = new ArrayList();
        do {
            TokenSequence seq = embedded;
            embedded = null;
            seq.move(offset);
            if (!seq.moveNext()) continue;
            sequences.add(seq);
            embedded = seq.embedded();
        } while (embedded != null);
        return sequences;
    }
}

