/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

public abstract class ResultsPanel
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.Bundle");
    private static final String CORNER_BUTTON_TOOLTIP = messages.getString("ResultsPanel_CornerButtonToolTip");
    protected NumberFormat intFormat;
    protected NumberFormat percentFormat;
    private boolean internalCornerButtonClick = false;

    public ResultsPanel() {
        this.setLayout(new BorderLayout());
        this.intFormat = NumberFormat.getIntegerInstance();
        this.intFormat.setGroupingUsed(true);
        this.percentFormat = NumberFormat.getPercentInstance();
        this.percentFormat.setMaximumFractionDigits(1);
        this.percentFormat.setMinimumFractionDigits(0);
    }

    public abstract void prepareResults();

    protected JButton createHeaderPopupCornerButton(final JPopupMenu headerPopup) {
        final JButton cornerButton = new JButton(Icons.getIcon((String)"GeneralIcons.HideColumn"));
        cornerButton.setToolTipText(CORNER_BUTTON_TOOLTIP);
        cornerButton.setDefaultCapable(false);
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            cornerButton.setMargin(new Insets(0, 0, 2, 2));
        } else if (UIUtils.isWindowsXPLookAndFeel()) {
            cornerButton.setMargin(new Insets(0, 0, 0, 1));
        } else if (UIUtils.isMetalLookAndFeel()) {
            cornerButton.setMargin(new Insets(0, 0, 2, 1));
        }
        cornerButton.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ ResultsPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 32) {
                    this.this$0.showColumnSelectionPopup(headerPopup, cornerButton);
                }
            }
        });
        cornerButton.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ ResultsPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (headerPopup.isVisible()) {
                    this.this$0.internalCornerButtonClick = true;
                    cornerButton.getModel().setArmed(false);
                } else {
                    this.this$0.internalCornerButtonClick = false;
                    if (mouseEvent.getModifiers() == 4) {
                        this.this$0.showColumnSelectionPopup(headerPopup, cornerButton);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16 && !this.this$0.internalCornerButtonClick) {
                    this.this$0.showColumnSelectionPopup(headerPopup, cornerButton);
                }
            }
        });
        return cornerButton;
    }

    protected JScrollPane createScrollPane() {
        JScrollPane jScrollPane = new JScrollPane();
        this.add((Component)jScrollPane, "Center");
        return jScrollPane;
    }

    protected JScrollPane createScrollPaneVerticalScrollBarAlways() {
        JScrollPane jScrollPane = this.createScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        final JScrollBar vScrollbar = jScrollPane.getVerticalScrollBar();
        vScrollbar.getModel().addChangeListener(new ChangeListener(){
            final /* synthetic */ ResultsPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                vScrollbar.setEnabled(this.this$0.isEnabled() && vScrollbar.getVisibleAmount() < vScrollbar.getMaximum());
            }
        });
        return jScrollPane;
    }

    protected abstract void initColumnSelectorItems();

    private void showColumnSelectionPopup(JPopupMenu headerPopup, JButton cornerButton) {
        this.initColumnSelectorItems();
        headerPopup.show(cornerButton, cornerButton.getWidth() - headerPopup.getPreferredSize().width, cornerButton.getHeight());
    }
}

