/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger.breakpoints;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.lsp.client.debugger.DAPDebugger;
import org.netbeans.modules.lsp.client.debugger.DAPStackTraceAnnotationHolder;
import org.netbeans.modules.lsp.client.debugger.breakpoints.DAPLineBreakpoint;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;

public final class BreakpointModel
implements NodeModel {
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    public static final String LINE_BREAKPOINT_PC = "org/netbeans/modules/debugger/resources/breakpointsView/BreakpointHit";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpoint";
    private List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof DAPLineBreakpoint) {
            DAPLineBreakpoint breakpoint = (DAPLineBreakpoint)((Object)node);
            FileObject fileObject = breakpoint.getFileObject();
            String nameExt = fileObject.getNameExt();
            return nameExt + ":" + breakpoint.getLineNumber();
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof DAPLineBreakpoint) {
            DAPLineBreakpoint breakpoint = (DAPLineBreakpoint)((Object)node);
            if (!((DAPLineBreakpoint)((Object)node)).isEnabled()) {
                return DISABLED_LINE_BREAKPOINT;
            }
            DAPDebugger debugger = BreakpointModel.getDebugger();
            if (debugger != null && DAPStackTraceAnnotationHolder.contains(debugger.getCurrentLine(), breakpoint.getLine())) {
                return LINE_BREAKPOINT_PC;
            }
            return LINE_BREAKPOINT;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof DAPLineBreakpoint) {
            DAPLineBreakpoint breakpoint = (DAPLineBreakpoint)((Object)node);
            return breakpoint.getFileObject().getPath() + ":" + breakpoint.getLineNumber();
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public void fireChanges() {
        ModelEvent.TreeChanged event = new ModelEvent.TreeChanged((Object)this);
        for (ModelListener l : this.listeners) {
            l.modelChanged((ModelEvent)event);
        }
    }

    private static DAPDebugger getDebugger() {
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (engine == null) {
            return null;
        }
        return (DAPDebugger)engine.lookupFirst(null, DAPDebugger.class);
    }
}

