/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.ui.annotation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.lib.chrome_devtools_protocol.debugger.CallFrame;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;
import org.netbeans.modules.javascript.cdtdebug.CDTScript;
import org.netbeans.modules.javascript.cdtdebug.ScriptsHandler;
import org.netbeans.modules.javascript.cdtdebug.ui.EditorUtils;
import org.netbeans.modules.javascript.cdtdebug.ui.annotation.CallStackAnnotation;
import org.netbeans.modules.javascript.cdtdebug.ui.annotation.CurrentLineAnnotation;
import org.openide.filesystems.FileObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.RequestProcessor;

public final class CallStackAnnotationListener
extends DebuggerManagerAdapter
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(CallStackAnnotationListener.class.getName());
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final Map<CDTDebugger, CDTDebugger.Listener> dbgListeners = new HashMap<CDTDebugger, CDTDebugger.Listener>();
    private volatile CDTDebugger currentCDTDbg;
    private final RequestProcessor annotationProcessor = new RequestProcessor(CallStackAnnotationListener.class);

    public String[] getProperties() {
        return new String[]{"debuggerEngines", "currentEngine"};
    }

    public void engineAdded(DebuggerEngine engine) {
        CDTDebugger dbg = (CDTDebugger)engine.lookupFirst(null, CDTDebugger.class);
        if (dbg != null) {
            DbgListener l = new DbgListener(dbg);
            this.dbgListeners.put(dbg, l);
            dbg.addListener((CDTDebugger.Listener)l);
            if (dbg == this.currentCDTDbg) {
                this.annotationProcessor.post((Runnable)new AnnotateTask(dbg));
            }
        }
    }

    public void engineRemoved(DebuggerEngine engine) {
        CDTDebugger dbg = (CDTDebugger)engine.lookupFirst(null, CDTDebugger.class);
        if (dbg != null) {
            CDTDebugger.Listener l = this.dbgListeners.remove(dbg);
            dbg.removeListener(l);
            if (dbg == this.currentCDTDbg) {
                this.annotationProcessor.post((Runnable)new AnnotateTask(null));
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "currentEngine": {
                CDTDebugger dbg;
                DebuggerEngine engine = (DebuggerEngine)evt.getNewValue();
                if (engine == null) break;
                this.currentCDTDbg = dbg = (CDTDebugger)engine.lookupFirst(null, CDTDebugger.class);
                this.annotationProcessor.post((Runnable)new AnnotateTask(dbg));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnnotations(CDTDebugger dbg) {
        this.clearAnnotations();
        if (!dbg.isSuspended()) {
            LOG.fine("updateAnnotations(), dbg is NOT suspended.");
            return;
        }
        List cs = dbg.getCurrentCallStack();
        LOG.log(Level.FINE, "updateAnnotations(), dbg IS suspended, call stack = {0}", cs);
        if (cs != null && !cs.isEmpty()) {
            ArrayList<Annotation> newAnnotations = new ArrayList<Annotation>();
            ScriptsHandler scriptsHandler = dbg.getScriptsHandler();
            boolean first = true;
            for (CallFrame f : cs) {
                Annotation anno;
                CDTScript script = dbg.getScriptsHandler().getScript(f.getLocation().getScriptId());
                if (script == null) continue;
                FileObject fo = scriptsHandler.getFile(script);
                Line line = EditorUtils.getLine(dbg, fo, f.getLocation().getLineNumber(), f.getLocation().getColumnNumber() != null ? f.getLocation().getColumnNumber() : 0);
                if (line == null) {
                    first = false;
                    continue;
                }
                if (first) {
                    anno = new CurrentLineAnnotation((Annotatable)line);
                    EditorUtils.showLine(line, true);
                    first = false;
                } else {
                    anno = new CallStackAnnotation((Annotatable)line);
                }
                newAnnotations.add(anno);
            }
            List<Annotation> list = this.annotations;
            synchronized (list) {
                LOG.log(Level.FINE, "Created and stored {0} annotations.", newAnnotations.size());
                this.annotations.addAll(newAnnotations);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAnnotations() {
        List<Annotation> list = this.annotations;
        synchronized (list) {
            LOG.log(Level.FINE, "Clearing {0} annotations.", this.annotations.size());
            for (Annotation ann : this.annotations) {
                ann.detach();
            }
            this.annotations.clear();
        }
    }

    private final class DbgListener
    implements CDTDebugger.Listener {
        private final CDTDebugger dbg;
        private volatile boolean topFrameShown;

        public DbgListener(CDTDebugger dbg) {
            this.dbg = dbg;
        }

        public void notifySuspended(boolean suspended) {
            if (CallStackAnnotationListener.this.currentCDTDbg == this.dbg) {
                if (suspended) {
                    CallStackAnnotationListener.this.annotationProcessor.post((Runnable)new AnnotateTask(this.dbg));
                    this.topFrameShown = true;
                } else {
                    CallStackAnnotationListener.this.annotationProcessor.post((Runnable)new AnnotateTask(null));
                    this.topFrameShown = false;
                }
            }
        }

        public void notifyCurrentFrame(CallFrame cf) {
            if (cf == null) {
                return;
            }
            if (this.topFrameShown && cf == this.dbg.getCurrentCallStack().get(0)) {
                return;
            }
            this.topFrameShown = false;
            CallStackAnnotationListener.this.annotationProcessor.execute(() -> EditorUtils.showFrameLine(this.dbg, cf, true));
        }

        public void notifyFinished() {
        }
    }

    private final class AnnotateTask
    implements Runnable {
        private final CDTDebugger dbg;

        public AnnotateTask(CDTDebugger dbg) {
            this.dbg = dbg;
        }

        @Override
        public void run() {
            if (this.dbg != null) {
                CallStackAnnotationListener.this.updateAnnotations(this.dbg);
            } else {
                CallStackAnnotationListener.this.clearAnnotations();
            }
        }
    }
}

